<?php $baseUrl = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\'); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Flowbot DCI - URL Processor</title>
    <link rel="stylesheet" href="<?= $baseUrl ?>/assets/css/style.css">
</head>
<body>
    <div class="app-container">
        <div class="card text-center">
            <h1>Flowbot DCI</h1>
            <p class="text-muted mb-2">Four-Phase Parallel URL Processor</p>

            <div class="mb-2">
                <span class="badge badge-primary">Process ID: <?= htmlspecialchars($processId) ?></span>
            </div>

            <form method="POST" action="?process_id=<?= htmlspecialchars($processId) ?>">
                <!-- SEC-006: CSRF Protection Token -->
                <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($csrfToken ?? '') ?>">

                <div class="form-group">
                    <textarea
                        name="web_url"
                        placeholder="Paste your URLs here, one per line...&#10;&#10;Example:&#10;https://example.com/article1&#10;https://example.com/article2&#10;https://another-site.com/page"
                        required
                    ></textarea>
                </div>

                <button type="submit" class="btn btn-primary btn-block">
                    Start Processing
                </button>
            </form>

            <div class="phase-info mt-3">
                <h4 class="mb-1">Processing Phases:</h4>
                <?php foreach ($phases as $i => $phase): ?>
                <p>
                    <strong>Phase <?= $i ?>:</strong>
                    <?= $phase['concurrency'] ?> concurrent requests,
                    <?= $phase['timeout'] ?>s timeout
                </p>
                <?php endforeach; ?>
            </div>
        </div>
    </div>

    <script src="<?= $baseUrl ?>/assets/js/app.js"></script>
</body>
</html>
