<?php
/**
 * Navigation Component - Flowb0t DCI v2.0
 * Shared navigation bar for all pages
 */

$baseUrl = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\');
$currentPage = $currentPage ?? 'dashboard';

// Calculate status
$remainingLinks = 0;
foreach ($data['phase_queues'] ?? [] as $queue) {
    $remainingLinks += count($queue);
}
$isComplete = ($remainingLinks === 0);
$statusClass = $isComplete ? 'complete' : 'processing';
if ($isComplete && ($data['error_links'] ?? 0) > 0) {
    $statusClass = 'has-errors';
}

// Progress percentage
$total = max($data['total_links'] ?? 1, 1);
$processed = ($data['processed_links'] ?? 0) + ($data['ignored_links'] ?? 0) + ($data['error_links'] ?? 0);
$progressPercent = round(($processed / $total) * 100, 1);
?>
<nav class="dashboard-nav">
    <div class="nav-brand">
        <span class="logo">F</span>
        <span class="brand-text">Flowb0t DCI</span>
        <span class="version">v2.0</span>
    </div>

    <div class="nav-links">
        <a href="?process_id=<?= urlencode($processId) ?>"
           class="nav-link <?= $currentPage === 'dashboard' ? 'active' : '' ?>">
            <span class="nav-icon">&#9776;</span>
            <span class="nav-text">Dashboard</span>
        </a>
        <a href="?process_id=<?= urlencode($processId) ?>&page=domains"
           class="nav-link <?= $currentPage === 'domains' ? 'active' : '' ?>">
            <span class="nav-icon">&#127760;</span>
            <span class="nav-text">Domains</span>
        </a>
        <a href="?process_id=<?= urlencode($processId) ?>&page=logs"
           class="nav-link <?= $currentPage === 'logs' ? 'active' : '' ?>">
            <span class="nav-icon">&#128196;</span>
            <span class="nav-text">Logs</span>
        </a>
    </div>

    <div class="nav-status">
        <div class="nav-progress-mini" title="<?= $progressPercent ?>% complete">
            <div class="nav-progress-fill" style="width: <?= $progressPercent ?>%"></div>
        </div>
        <span class="status-indicator <?= $statusClass ?>" title="<?= $isComplete ? 'Complete' : 'Processing...' ?>"></span>
        <span class="process-id" title="Process ID: <?= htmlspecialchars($processId) ?>">
            <?= htmlspecialchars(substr($processId, 0, 12)) ?>...
        </span>
    </div>
</nav>
