<?php
$base = rtrim(str_replace('\\','/', dirname($_SERVER['SCRIPT_NAME'] ?? '')), '/.');
if ($base) $base .= '/';
?><!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Profile – DigUpDog Masonry</title>
  <link rel="stylesheet" href="<?php echo $base; ?>public/css/styles.css">
</head>
<body>
<header>
  <div class="container">
    <div class="brand"><span class="logo"></span> <span>DigUpDog Masonry</span></div>
    <nav>
      <a href="<?php echo $base; ?>index.php">Home</a>
      <a href="<?php echo $base; ?>trending.php">Trending</a>
      <a href="<?php echo $base; ?>sources.php">Sources</a>
      <a class="active" href="<?php echo $base; ?>profile.php">Profile</a>
      <a href="<?php echo $base; ?>login.php">Login</a>
    </nav>
  </div>
</header>

<main class="container" id="root">
  <div class="notice">Loading profile…</div>
</main>

<script>
async function loadProfile(){
  const urlParams = new URLSearchParams(location.search);
  const uid = urlParams.get('user_id') || 'me';
  const r = await fetch('api/router.php?action=get_user_profile&user_id=' + encodeURIComponent(uid));
  const j = await r.json();
  const root = document.getElementById('root');
  if (!j.ok) { root.innerHTML = '<div class="empty">'+(j.message||j.error)+'</div>'; return; }
  const u = j.user, s = j.stats;
  root.innerHTML = `
  <div class="card">
    <div class="content">
      <h2>${u.username || u.email}</h2>
      <div class="meta">
        <span class="kv">ID: ${u.ID}</span>
        <span class="kv">Member since: ${u.created_at||''}</span>
      </div>
      <div class="meta">
        <span class="badge">Feeds: ${s.feeds}</span>
        <span class="badge">Favorites: ${s.favorites}</span>
        <span class="badge">Comments: ${s.comments}</span>
        <span class="badge">Followers: ${s.followers}</span>
        <span class="badge">Following: ${s.following}</span>
      </div>
      <div class="actions">
        <a class="ghost" style="flex:1;text-align:center" href="logout.php">Logout</a>
      </div>
    </div>
  </div>
  `;
}
document.addEventListener('DOMContentLoaded', loadProfile);
</script>
</body>
</html>
