// loadFeeds.js - VERSÃO CORRIGIDA PARA SCROLL INICIAL
// Substitua TODO o conteúdo do seu loadFeeds.js por este:

function loadFeeds() {
    return new Promise((resolve, reject) => {
        if (loading) {
            console.log('Já está carregando, aguarde...');
            resolve();
            return;
        }
        
        loading = true;
        var searchTerm = $('#search-query').val();
        var timestamp = new Date().getTime();
        
        console.log('===== CARREGANDO FEEDS =====');
        console.log('Página:', page);
        console.log('Busca:', searchTerm || '(vazio - carregamento inicial)');
        console.log('Feeds existentes:', Object.keys(feeds).length);
        
        $.ajax({
            url: 'get_pinfeeds.php',
            type: 'GET',
            dataType: 'json',
            data: { 
                page: page, 
                search: searchTerm, 
                t: timestamp 
            },
            success: function(data) {
                console.log('Resposta recebida:');
                console.log('- Feeds recebidos:', data.length);
                console.log('- Primeira página?', page === 1);
                
                // IMPORTANTE: Não limpa feeds em páginas subsequentes
                if (page === 1) {
                    console.log('Limpando feeds e displayedFeeds (página 1)...');
                    feeds = {};
                    displayedFeeds = {};
                }
                
                // Adiciona novos feeds ao objeto
                let newFeedsCount = 0;
                $.each(data, function(index, feed) {
                    // Usa ID ou link como chave única
                    var uniqueKey = feed.id || feed.link;
                    
                    // CORREÇÃO: Sempre adiciona feeds novos, mesmo que o link seja o mesmo
                    // mas com ID diferente (para suportar paginação)
                    if (!feeds[uniqueKey]) {
                        feeds[uniqueKey] = feed;
                        newFeedsCount++;
                    }
                });
                
                console.log('- Novos feeds adicionados:', newFeedsCount);
                console.log('- Total de feeds agora:', Object.keys(feeds).length);
                
                // CORREÇÃO PRINCIPAL: Sempre chama displayAllFeeds para inicial
                if (searchTerm === '') {
                    console.log('Sem busca - exibindo todos os feeds...');
                    displayAllFeeds();
                } else {
                    console.log('Com busca - filtrando feeds...');
                    displayFeeds();
                }
                
                loading = false;
                resolve(data);
            },
            error: function(xhr, status, error) {
                console.error('ERRO ao carregar feeds:');
                console.error('- Status:', status);
                console.error('- Error:', error);
                console.error('- Response:', xhr.responseText);
                
                try {
                    var errorData = JSON.parse(xhr.responseText);
                    if (errorData.error) {
                        alert('Erro: ' + errorData.error);
                    } else {
                        alert('Não foi possível carregar os feeds. Por favor, tente novamente.');
                    }
                } catch (e) {
                    alert('Não foi possível carregar os feeds. Por favor, tente novamente.');
                }
                
                loading = false;
                reject(error);
            },
            complete: function() {
                console.log('===== FIM DO CARREGAMENTO =====\n');
            }
        });
    });
}

// Nova função para exibir todos os feeds (sem filtro de imagem)
function displayAllFeeds() {
    console.log('displayAllFeeds() chamada');
    
    var container = $('#feeds');
    var allFeedsArray = [];
    
    // Converte o objeto feeds em array
    $.each(feeds, function(key, feed) {
        allFeedsArray.push(feed);
    });
    
    console.log('Total de feeds para processar:', allFeedsArray.length);
    
    // Chama displayFeedsToContainer que vai gerenciar o que já foi exibido
    displayFeedsToContainer(allFeedsArray, container);
}

// Função para verificar se precisa carregar mais feeds
function checkAndLoadMore() {
    const scrollPosition = $(window).scrollTop() + $(window).height();
    const documentHeight = $(document).height();
    const threshold = 1000;
    
    console.log('checkAndLoadMore() - Verificando necessidade de mais feeds...');
    console.log('- Posição do scroll:', scrollPosition);
    console.log('- Altura do documento:', documentHeight);
    console.log('- Threshold:', documentHeight - threshold);
    console.log('- Loading:', loading);
    
    if (scrollPosition > documentHeight - threshold && !loading) {
        console.log('Precisa carregar mais feeds!');
        page++;
        loadFeeds().then(function() {
            console.log('Mais feeds carregados com sucesso');
            // Verifica novamente após carregar
            setTimeout(checkIfNeedMoreContent, 500);
        }).catch(function(error) {
            console.error('Erro ao carregar mais feeds:', error);
            page--; // Volta a página em caso de erro
        });
    } else {
        console.log('Não precisa carregar mais feeds ainda');
    }
}

// Função para verificar se precisa de mais conteúdo para preencher a tela
function checkIfNeedMoreContent() {
    const windowHeight = $(window).height();
    const documentHeight = $(document).height();
    const scrollTop = $(window).scrollTop();
    const hasContent = $('#feeds .result').length > 0;
    
    console.log('checkIfNeedMoreContent() - Verificando se precisa mais conteúdo...');
    console.log('- Altura da janela:', windowHeight);
    console.log('- Altura do documento:', documentHeight);
    console.log('- Scroll top:', scrollTop);
    console.log('- Tem conteúdo?', hasContent);
    console.log('- Loading:', loading);
    
    // Se o conteúdo é menor que a janela + 100px, carrega mais
    if (documentHeight - scrollTop <= windowHeight + 100 && !loading && hasContent) {
        console.log('Tela não está cheia, carregando mais feeds...');
        page++;
        loadFeeds().then(function() {
            // Verifica novamente após carregar
            setTimeout(checkIfNeedMoreContent, 500);
        }).catch(function(error) {
            console.error('Erro ao carregar feeds adicionais:', error);
            page--;
        });
    } else {
        console.log('Tela está cheia ou ainda carregando');
    }
}

// Inicialização quando o documento estiver pronto
$(document).ready(function() {
    console.log('loadFeeds.js - Documento pronto');
    
    // Inicializa variáveis globais se não existirem
    if (typeof window.feeds === 'undefined') {
        window.feeds = {};
        console.log('Variável feeds inicializada');
    }
    if (typeof window.displayedFeeds === 'undefined') {
        window.displayedFeeds = {};
        console.log('Variável displayedFeeds inicializada');
    }
    if (typeof window.page === 'undefined') {
        window.page = 1;
        console.log('Variável page inicializada');
    }
    if (typeof window.loading === 'undefined') {
        window.loading = false;
        console.log('Variável loading inicializada');
    }
    if (typeof window.loadThreshold === 'undefined') {
        window.loadThreshold = 20000;
        console.log('Variável loadThreshold inicializada');
    }
    
    console.log('Variáveis globais prontas');
});

// Função de debug específica para o problema
window.debugLoadingIssue = function() {
    console.log('=== DEBUG PROBLEMA DE CARREGAMENTO ===');
    console.log('Página atual:', page);
    console.log('Loading:', loading);
    console.log('Feeds carregados:', Object.keys(feeds).length);
    console.log('Feeds exibidos:', Object.keys(displayedFeeds).length);
    console.log('Elements no DOM:', $('#feeds .result').length);
    console.log('Altura documento:', $(document).height());
    console.log('Altura janela:', $(window).height());
    console.log('Busca ativa?', $('#search-query').val() !== '');
    
    // Testa se há feeds não exibidos
    let notDisplayed = 0;
    $.each(feeds, function(key, feed) {
        if (!displayedFeeds[key] && !displayedFeeds[feed.id] && !displayedFeeds[feed.link]) {
            notDisplayed++;
        }
    });
    console.log('Feeds carregados mas não exibidos:', notDisplayed);
    
    console.log('======================================');
};