<?php
// create_indexes.php - Cria índices automaticamente
// ACESSE: seu-site.com/create_indexes.php

set_time_limit(0); // Sem limite de tempo
header('Content-Type: text/html; charset=utf-8');

?>
<!DOCTYPE html>
<html>
<head>
    <title>Criar Índices - Otimização</title>
    <style>
        body { font-family: Arial; margin: 20px; background: #f5f5f5; }
        .container { max-width: 800px; margin: 0 auto; background: white; padding: 20px; border-radius: 10px; }
        .success { color: green; }
        .error { color: red; }
        .warning { color: orange; }
        .progress { background: #e0e0e0; height: 30px; border-radius: 5px; margin: 10px 0; }
        .progress-bar { background: #4CAF50; height: 100%; border-radius: 5px; transition: width 0.5s; }
        button { background: #2196F3; color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; font-size: 16px; }
        button:hover { background: #1976D2; }
        .log { background: #f0f0f0; padding: 10px; border-radius: 5px; margin: 10px 0; font-family: monospace; }
    </style>
</head>
<body>
<div class="container">
    <h1>🚀 Otimização de Banco de Dados</h1>
    <p>Este script criará os índices necessários para melhorar a performance em até <strong>50x</strong>!</p>
    
    <?php
    if (!isset($_POST['confirm'])) {
    ?>
        <div class="warning">
            <h3>⚠️ Aviso Importante:</h3>
            <ul>
                <li>Este processo pode demorar 30-60 minutos para 33M de registros</li>
                <li>O site pode ficar lento durante a criação dos índices</li>
                <li>Recomendado executar em horário de baixo tráfego</li>
            </ul>
        </div>
        
        <form method="post">
            <button type="submit" name="confirm" value="1">✓ Entendi, Criar Índices Agora</button>
        </form>
    <?php
    } else {
        // Conecta ao banco
        try {
            $conn = new PDO('mysql:host=localhost;dbname=digupdog_FEED;charset=utf8mb4', 
                            'digupdog_FEEDadmin', 'Raimundinho1');
            $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            
            echo "<h3>Criando índices...</h3>";
            echo "<div class='progress'><div class='progress-bar' id='progress' style='width: 0%'></div></div>";
            echo "<div id='status'></div>";
            
            // Lista de índices para criar
            $indexes = [
                [
                    'table' => 'pinfeeds',
                    'name' => 'idx_id_desc',
                    'columns' => 'id DESC',
                    'importance' => 'CRÍTICO'
                ],
                [
                    'table' => 'comments',
                    'name' => 'idx_feed_created',
                    'columns' => 'feed_id, created_at DESC',
                    'importance' => 'ESSENCIAL'
                ],
                [
                    'table' => 'title_description_index',
                    'name' => 'idx_word_feed',
                    'columns' => 'word, feed_id',
                    'importance' => 'IMPORTANTE'
                ],
                [
                    'table' => 'favorites',
                    'name' => 'idx_user_feed',
                    'columns' => 'user_id, feed_id',
                    'importance' => 'ÚTIL'
                ],
                [
                    'table' => 'likes_dislikes',
                    'name' => 'idx_user_feed',
                    'columns' => 'user_id, feed_id',
                    'importance' => 'ÚTIL'
                ]
            ];
            
            $total = count($indexes);
            $created = 0;
            
            foreach ($indexes as $index) {
                echo "<div class='log'>";
                echo "Processando: <strong>{$index['table']}.{$index['name']}</strong> ({$index['importance']})... ";
                flush();
                
                // Verifica se o índice já existe
                $check = $conn->query("SHOW INDEX FROM {$index['table']} WHERE Key_name = '{$index['name']}'")->fetch();
                
                if ($check) {
                    echo "<span class='warning'>Já existe!</span>";
                } else {
                    try {
                        $start = microtime(true);
                        $sql = "ALTER TABLE {$index['table']} ADD INDEX {$index['name']} ({$index['columns']})";
                        $conn->exec($sql);
                        $time = round(microtime(true) - $start, 2);
                        echo "<span class='success'>✓ Criado em {$time}s</span>";
                    } catch (Exception $e) {
                        echo "<span class='error'>✗ Erro: " . $e->getMessage() . "</span>";
                    }
                }
                
                echo "</div>";
                
                $created++;
                $percent = round(($created / $total) * 100);
                
                echo "<script>
                    document.getElementById('progress').style.width = '{$percent}%';
                    document.getElementById('status').innerHTML = 'Progresso: {$created}/{$total} índices processados';
                </script>";
                
                flush();
            }
            
            // Otimiza tabelas
            echo "<h3>Otimizando tabelas...</h3>";
            echo "<div class='log'>";
            
            try {
                echo "Analisando tabela pinfeeds... ";
                flush();
                $conn->exec("ANALYZE TABLE pinfeeds");
                echo "<span class='success'>✓</span><br>";
                
                echo "Analisando tabela comments... ";
                flush();
                $conn->exec("ANALYZE TABLE comments");
                echo "<span class='success'>✓</span><br>";
            } catch (Exception $e) {
                echo "<span class='error'>Erro: " . $e->getMessage() . "</span>";
            }
            
            echo "</div>";
            
            // Testa performance
            echo "<h3>Testando performance...</h3>";
            echo "<div class='log'>";
            
            $start = microtime(true);
            $conn->query("SELECT * FROM pinfeeds ORDER BY id DESC LIMIT 21")->fetchAll();
            $time = round((microtime(true) - $start) * 1000, 2);
            
            echo "Query de teste executada em: <strong>{$time}ms</strong> ";
            
            if ($time < 100) {
                echo "<span class='success'>✓ Excelente!</span>";
            } elseif ($time < 500) {
                echo "<span class='warning'>⚠ Bom</span>";
            } else {
                echo "<span class='error'>✗ Ainda lento</span>";
            }
            
            echo "</div>";
            
            echo "<div class='success' style='margin-top: 20px; padding: 20px; border: 2px solid green; border-radius: 10px;'>";
            echo "<h2>✅ Processo Concluído!</h2>";
            echo "<p>Os índices foram criados com sucesso. Sua aplicação deve estar significativamente mais rápida agora!</p>";
            echo "<p><strong>Próximos passos:</strong></p>";
            echo "<ol>";
            echo "<li>Teste o site para verificar a melhoria de velocidade</li>";
            echo "<li>Use o arquivo <code>get_pinfeeds_ultra.php</code> para melhor performance</li>";
            echo "<li>Monitore o desempenho regularmente</li>";
            echo "</ol>";
            echo "</div>";
            
        } catch (PDOException $e) {
            echo "<div class='error'>";
            echo "<h3>❌ Erro de Conexão</h3>";
            echo "<p>" . $e->getMessage() . "</p>";
            echo "</div>";
        }
    }
    ?>
</div>
</body>
</html>