<!DOCTYPE html>
<html lang="pt-BR">
<head><meta charset="utf-8"><meta http-equiv="X-UA-Compatible" content="IE=edge"><meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>Pr&eacute;-Visualiza&ccedil;&atilde;o e Edi&ccedil;&atilde;o</title>
	<link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet" />
	<style type="text/css">body {
            font-family: Arial, sans-serif;
            font-size: 20px;
            background-color: #ffffff;
            margin: 0;
            padding-top: 50px; /* Adiciona espaço para a barra de busca fixa */
        }

/* Estilos para o modo escuro */
body.dark-mode {
  background-color: #333;
  color: #fff;
}

.short-text {
    display: none; /* esconde o texto curto por padrão */
}

@media (max-width: 768px) {
    .full-text {
        display: none; /* esconde o texto completo em telas pequenas */
    }

    .short-text {
        display: inline; /* mostra o texto curto em telas pequenas */
    }
}


        @media (min-width: 4800px) {
            .result-list {
                grid-template-columns: repeat(auto-fill, minmax(180px, 1fr));
            }
        }






    /* Estilos para o rodapé */
    footer {
        position: fixed;
        left: 0;
        bottom: 0;
        width: 100%;
        text-align: center;
        font-size: 8px;
        padding: 3px;
        background-color: #f2f2f2;
        border-top: 1px solid #ccc;
    }



.category-buttons-container {
  position: fixed;
  top: 25px;
  left: 0;
  right: 0;
  z-index: 998;
  max-width: 100%;
  width: 90%;
  margin-left: auto;
  margin-right: auto;
  overflow-x: auto;
  white-space: nowrap;
  padding: 5px;
  background-color: transparent; /* Torna o fundo transparente */
  box-shadow: 0 2px 10px rgba(0,0,0,0.1); /* Adicione sombra para profundidade */
  overflow: hidden;
}

.category-buttons {
  display: flex;
  justify-content: space-between; /* Posiciona os botões nas extremidades */
  align-items: center;
}

.left-arrow,
.right-arrow {
  display: flex;
  align-items: center;
  justify-content: center;
  width: 30px;
  height: 30px;
  background-color: #F7F7F7;
  border-radius: 50%;
  font-size: 1.2rem;
  color: #333333;
  cursor: pointer;
  transition: background-color 0.3s ease, transform 0.3s ease;
  box-shadow: 0 2px 5px rgba(0,0,0,0.1); /* Adicione sombra para profundidade */
}

.left-arrow:hover,
.right-arrow:hover {
  background-color: #EAEAEA;
  transform: scale(1.1); /* Efeito de zoom ao passar o mouse */
}

.category-button {
    margin: 0 0.5rem;
    background-color: #F7F7F7;
    border: none;
    border-radius: 0.4rem;
    padding: 0.5rem 1rem;
    font-size: 0.8rem;
    cursor: pointer;
    transition: background-color 0.3s ease, transform 0.3s ease;
    font-family: 'Arial', sans-serif; /* Substitua por qualquer fonte de sua escolha */
    box-shadow: 0 2px 5px rgba(0,0,0,0.1); /* Adicione sombra para profundidade */
}

.category-button:hover {
    background-color: #EAEAEA;
    transform: scale(1.05); /* Adicione um efeito de "zoom" ao passar o mouse */
}

        .category-buttons-wrapper {
            display: flex;
            align-items: center;
            overflow-x: auto;
            scrollbar-width: none;
        }

        .category-buttons-wrapper::-webkit-scrollbar {
            display: none;
        }

.category-button.all {
    background-color: #e8e9e8;
    color: #000000;
    font-weight: bold;
    font-size: 20px;
    text-decoration: none;
    border: none;
    padding: 0 5px; /* Espaçamento horizontal de 5px */
    border-radius: 4px;
    line-height: 32px; /* Altura da linha para controlar o espaçamento vertical */
    transition: background-color 0.3s ease; /* Transição suave para a mudança de cor de fundo */
}

.category-button.all:hover {
    background-color: #d2d3d2;
}


.category-button.world-news {
    background-color: #e8e9e8;
    color: #000000;
    font-weight: bold;
    font-size: 20px;
    text-decoration: none;
    border: none;
    padding: 0 5px; /* Espaçamento horizontal de 5px */
    border-radius: 4px;
    line-height: 32px; /* Altura da linha para controlar o espaçamento vertical */
    transition: background-color 0.3s ease; /* Transição suave para a mudança de cor de fundo */
}}

.category-button.world-news:hover {
    background-color: #d2d3d2;
}

.category-button.entertainment {
    background-color: #e8e9e8;
    color: #000000;
    font-weight: bold;
    font-size: 20px;
    text-decoration: none;
    border: none;
    padding: 0 5px; /* Espaçamento horizontal de 5px */
    border-radius: 4px;
    line-height: 32px; /* Altura da linha para controlar o espaçamento vertical */
    transition: background-color 0.3s ease; /* Transição suave para a mudança de cor de fundo */
}

.category-button.entertainment:hover {
    background-color: #d2d3d2;
}


.category-button.sports {
    background-color: #e8e9e8;
    color: #000000;
    font-weight: bold;
    font-size: 20px;
    text-decoration: none;
    border: none;
    padding: 0 5px; /* Espaçamento horizontal de 5px */
    border-radius: 4px;
    line-height: 32px; /* Altura da linha para controlar o espaçamento vertical */
    transition: background-color 0.3s ease; /* Transição suave para a mudança de cor de fundo */
}

.category-button.sports:hover {
    background-color: #d2d3d2;
}

.category-button.videogames {
    background-color: #e8e9e8;
    color: #000000;
    font-weight: bold;
    font-size: 20px;
    text-decoration: none;
    border: none;
    padding: 0 5px; /* Espaçamento horizontal de 5px */
    border-radius: 4px;
    line-height: 32px; /* Altura da linha para controlar o espaçamento vertical */
    transition: background-color 0.3s ease; /* Transição suave para a mudança de cor de fundo */
}

.category-button.videogames:hover {
    background-color: #d2d3d2;
}

.category-button.pins {
    background-color: #1f8aef;
    color: #ffffff;
    font-weight: bold;
    font-size: 20px;
    text-decoration: none;
    border: none;
    padding: 0 5px; /* Espaçamento horizontal de 5px */
    border-radius: 4px;
    line-height: 32px; /* Altura da linha para controlar o espaçamento vertical */
    transition: background-color 0.3s ease; /* Transição suave para a mudança de cor de fundo */
}

.category-button.pins:hover {
    background-color: #d2d3d2;
}

.category-button.plus {
    background-color: #ff0000;
    color: #ffffff;
    font-weight: bold;
    font-size: 20px;
    text-decoration: none;
    border: none;
    padding: 0 5px; /* Espaçamento horizontal de 5px */
    border-radius: 4px;
    line-height: 32px; /* Altura da linha para controlar o espaçamento vertical */
    transition: background-color 0.3s ease; /* Transição suave para a mudança de cor de fundo */
}

.category-button.plus:hover {
    background-color: #d2d3d2;
}

.category-button.pin {
    background-color: #1f8aef;
    color: #ffffff;
    font-weight: bold;
    font-size: 20px;
    text-decoration: none;
    border: none;
    padding: 0 10px; /* Espaçamento horizontal de 10px */
    border-radius: 4px;
    line-height: 32px; /* Altura da linha para controlar o espaçamento vertical */
    transition: background-color 0.3s ease; /* Transição suave para a mudança de cor de fundo */
}

.category-button.pin:hover {
    background-color: #f8ae01;
}
#myBtn {
            display: none;
            position: fixed;
            bottom: 40px;
            right: 12px;
            z-index: 99;
            font-size: 18px;
            border: none;
            outline: none;
            background-color: red;
            color: white;
            cursor: pointer;
            padding: 15px;
            border-radius: 4px;
        }

        #myBtn:hover {
            background-color: #d2d3d2;
        }


/* Estilos para o botão "Modo Escuro" */
#dark-mode-toggle {
            background-color: #333;
            border: none;
            border-radius: .4rem;
            color: #ffffff;
            cursor: pointer;
            font-size: 1.5rem;
            font-weight: bold;
            height: 2rem;
            width: 10%; /* ajuste esta porcentagem conforme necessário */
            outline: none;
            transition: background-color 0.3s ease;
            display: flex;
            justify-content: center;
            align-items: center;
    overflow: visible; /* permite que o conteúdo ultrapasse os limites do botão */
  margin-right: 5px;
}

#dark-mode-toggle:hover {
  background-color: #555;
}
	</style>
</head>
<body>
<div class="category-buttons-container">
<div class="category-buttons">
<div class="left-arrow"></div>

<div class="category-buttons-wrapper"><a class="category-button pins" href="https://digupdog.com/" target="_self">Pins</a><a class="category-button all" href="https://digupdog.net/FEED/home.html" target="_self">All</a><a class="category-button world-news" href="https://digupdog.net/FEED/news.html" target="_self">World News</a><a class="category-button entertainment" href="https://digupdog.net/FEED/entertainment.html" target="_self">Entertainment</a><a class="category-button sports" href="https://digupdog.net/FEED/sports.html" target="_self">Sports</a><a class="category-button videogames" href="https://digupdog.net/FEED/videogames.html" target="_self">Video Games</a><a class="category-button plus" href="https://digupdog.com/plus" target="_self">18+</a><a class="category-button pin" href="https://digupdog.com/aaa1" target="_self">+</a><button id="dark-mode-toggle"><span class="full-text">DARK</span><span class="short-text">D</span></button></div>

<div class="right-arrow"></div>
</div>
</div>


<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script><script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script><script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script><script>
var container = document.querySelector('.category-buttons-container');
var wrapper = document.querySelector('.category-buttons-wrapper');
var leftArrow = document.querySelector('.left-arrow');
var rightArrow = document.querySelector('.right-arrow');
var scrollAmount = 0;
var scrollStep = 5;
var scrollInterval;

function startScrollLeft() {
    scrollInterval = setInterval(function() {
        wrapper.scrollLeft -= scrollStep;  // Ajuste o valor de scrollLeft diretamente
    }, 10);
}

function startScrollRight() {
    scrollInterval = setInterval(function() {
        wrapper.scrollLeft += scrollStep;  // Ajuste o valor de scrollLeft diretamente
    }, 10);
}

function stopScroll() {
  clearInterval(scrollInterval);
}

leftArrow.addEventListener('mousedown', startScrollLeft);
leftArrow.addEventListener('mouseup', stopScroll);
leftArrow.addEventListener('mouseleave', stopScroll);
rightArrow.addEventListener('mousedown', startScrollRight);
rightArrow.addEventListener('mouseup', stopScroll);
rightArrow.addEventListener('mouseleave', stopScroll);

leftArrow.addEventListener('touchstart', startScrollLeft);
leftArrow.addEventListener('touchend', stopScroll);
rightArrow.addEventListener('touchstart', startScrollRight);
rightArrow.addEventListener('touchend', stopScroll);



// Seletor para o botão de alternar modo escuro
const darkModeToggle = document.querySelector('#dark-mode-toggle');

// Evento de clique no botão
darkModeToggle.addEventListener('click', function() {
  // Adiciona ou remove a classe 'dark-mode' no elemento body
  document.body.classList.toggle('dark-mode');
});

</script></body>
</html>



<?php
$host = 'localhost';
$db   = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';
$error_message = "";

try {
    $conn = new PDO("mysql:host=$host;dbname=$db;charset=$charset", $user, $pass);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    $error_message = 'Erro na conexão com o banco de dados: ' . $e->getMessage();
}

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['id'])) {
    $id = $_POST['id'];
    $title = $_POST['title'];
    $description = $_POST['description'];
    $tags = $_POST['tags'];
    $thumbnail = $_POST['thumbnail'];

    if ($_FILES['newThumbnail']['error'] === UPLOAD_ERR_OK) {
        $tempFile = $_FILES['newThumbnail']['tmp_name'];
        $newThumbnailFilename = basename($_FILES['newThumbnail']['name']);
        $newThumbnailPath = '/home/https://digupdog.com/uploads/' . $newThumbnailFilename;
        move_uploaded_file($tempFile, $newThumbnailPath);
        $newThumbnail = 'https://digupdog.com/uploads/' . $newThumbnailFilename;
    } else {
        $newThumbnail = $_POST['thumbnail'];
    }

    $updateQuery = "UPDATE pinfeeds SET title = ?, description = ?, tags = ?, thumbnail = ? WHERE id = ?";
    try {
        $stmt = $conn->prepare($updateQuery);
        $stmt->execute([$title, $description, $tags, $newThumbnail, $id]);
        $success_message = "Dados atualizados com sucesso!";
    } catch (PDOException $e) {
        $error_message = 'Erro ao atualizar os dados: ' . $e->getMessage();
    }
}

if (isset($_GET['id'])) {
    $id = $_GET['id'];
    $query = "SELECT * FROM pinfeeds WHERE id = ?";
    try {
        $stmt = $conn->prepare($query);
        $stmt->execute([$id]);
        $feed = $stmt->fetch(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        $error_message = 'Erro na consulta ao banco de dados: ' . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Feed</title>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            padding-top: 50px;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f5f5f5;
        }
        .container {
            max-width: 600px;
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            padding: 20px;
            margin-top: 20px;
        }
        @media (min-width: 576px) {
            body {
                padding-top: 80px;
            }
        }
        @media (min-width: 768px) {
            body {
                padding-top: 100px;
            }
            .container {
                max-width: 800px;
            }
        }
        @media (min-width: 992px) {
            .container {
                max-width: 1000px;
            }
        }
        @media (min-width: 1200px) {
            .container {
                max-width: 1200px;
            }
        }
        h2 {
            font-size: 1.8rem;
            margin-bottom: 1.5rem;
        }
        .alert {
            margin-top: 1.5rem;
            margin-bottom: 1rem;
            padding: 15px;
            border-radius: 6px;
        }
        .btn-primary {
            background-color: #007bff;
            border-color: #007bff;
            transition: background-color 0.2s, border-color 0.2s;
        }
        .btn-primary:hover {
            background-color: #0056b3;
            border-color: #0056b3;
        }
        .btn-secondary {
            color: #fff;
            background-color: #6c757d;
            border-color: #6c757d;
            transition: background-color 0.2s, border-color 0.2s;
        }
        .btn-secondary:hover {
            background-color: #545b62;
            border-color: #4e555b;
        }
    </style>
</head>
<body>

<div class="container">
    <?php if (isset($success_message)): ?>
    <div class="alert alert-success">
        <?php echo $success_message; ?>
    </div>
<a href='pindetails.php?id=<?php echo $id; ?>' class="btn btn-secondary">Voltar para Visualizar</a>

<button type="button" class="btn btn-danger" id="delete-btn">Delete</button>


    <?php elseif (isset($feed)): ?>
    <h2>Editar Feed</h2>
    <form action="edit.php" method="post" enctype="multipart/form-data">

        <input type="hidden" name="id" value="<?php echo $id; ?>" />
        <div class="form-group">
            <label for="title">Título:</label>
            <input type="text" class="form-control" name="title" value="<?php echo htmlspecialchars($feed['title'], ENT_QUOTES, 'UTF-8'); ?>">
        </div>
        <div class="form-group">
            <label for="description">Descrição:</label>
            <textarea class="form-control" name="description"><?php echo htmlspecialchars($feed['description'], ENT_QUOTES, 'UTF-8'); ?></textarea>
        </div>
        <div class="form-group">
            <label for="tags">Tags:</label>
            <input type="text" class="form-control" name="tags" value="<?php echo htmlspecialchars($feed['tags'], ENT_QUOTES, 'UTF-8'); ?>">
        </div>
        <div class="form-group">
            <label for="thumbnail">Thumbnail URL:</label>
            <input type="text" class="form-control" name="thumbnail" value="<?php echo htmlspecialchars($feed['thumbnail'], ENT_QUOTES, 'UTF-8'); ?>">
        </div>
        <div class="form-group">
            <img id="thumbnail-preview" src="<?php echo htmlspecialchars($feed['thumbnail'], ENT_QUOTES, 'UTF-8'); ?>" alt="Thumbnail" class="img-thumbnail mb-2" style="max-width: 300px;">
            <label for="newThumbnail">Nova Imagem:</label>
            <input type="file" class="form-control-file" name="newThumbnail" accept="image/*" onchange="previewImage(this);">
        </div>
        <button type="submit" class="btn btn-primary">Atualizar</button>
        <button type="button" class="btn btn-danger" id="delete-btn">Delete</button>

    </form>
    <?php else: ?>
    <div class="alert alert-danger">
        <?php echo $error_message; ?>
    </div>
    <?php endif; ?>
</div>

<script>
    function previewImage(input) {
        console.log("Função previewImage chamada."); 
        var preview = document.getElementById('thumbnail-preview');
        console.log(preview); 
        if (input.files && input.files[0]) {
            console.log("Arquivo selecionado:", input.files[0]);
            var reader = new FileReader();
            reader.onload = function(e) {
                console.log("Leitura concluída:", e.target.result); 
                preview.src = e.target.result;
            };
            reader.readAsDataURL(input.files[0]);
        } else {
            console.log("Nenhum arquivo selecionado.");
        }
    }
    
    
    document.getElementById('delete-btn').addEventListener('click', function() {
    if (confirm('Você tem certeza que deseja deletar este post?')) {
        window.location.href = 'delete.php?id=' + <?php echo $id; ?>;
    }
});


</script>


<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

</body>
</html>