<?php
session_start();

// Conexão com o Banco de Dados
$host = 'localhost';
$db = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';

// Configurações de conexão PDO
$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES => false,
];

try {
    // Faz a conexão com o banco de dados
    $conn = new PDO($dsn, $user, $pass, $options);
} catch (PDOException $e) {
    // Se ocorrer um erro, exibe a mensagem e encerra a execução
    echo json_encode(['success' => false, 'message' => 'Erro ao conectar ao banco de dados']);
    exit();
}

// Verifica se os dados foram enviados corretamente
if (isset($_POST['action']) && isset($_POST['follow_type']) && isset($_POST['follow_value'])) {
    $action = $_POST['action']; // Ação: seguir ou desseguir
    $followType = $_POST['follow_type']; // Tipo de follow: author, tag, ou source_domain
    $followValue = $_POST['follow_value']; // Valor do follow: nome do autor, tag ou domínio

    // Vamos buscar o ID do usuário logado (assumindo que você tem um sistema de login)
    if (!isset($_SESSION['user_id'])) {
        echo json_encode(['success' => false, 'message' => 'Usuário não está logado']);
        exit();
    }

    $userId = $_SESSION['user_id']; // Ajuste conforme seu sistema de login

    if ($action === 'follow') {
        // Adiciona o follow ao banco de dados
        $query = "INSERT INTO follows (user_id, follow_type, follow_value) VALUES (?, ?, ?)";
        $stmt = $conn->prepare($query);
        $result = $stmt->execute([$userId, $followType, $followValue]);
        
        if ($result) {
            echo json_encode(['success' => true, 'status' => 'following']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Erro ao seguir']);
        }
    } elseif ($action === 'unfollow') {
        // Remove o follow do banco de dados
        $query = "DELETE FROM follows WHERE user_id = ? AND follow_type = ? AND follow_value = ?";
        $stmt = $conn->prepare($query);
        $result = $stmt->execute([$userId, $followType, $followValue]);
        
        if ($result) {
            echo json_encode(['success' => true, 'status' => 'not-following']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Erro ao desseguir']);
        }
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Dados inválidos']);
}

$conn = null; // Encerra a conexão com o banco de dados
?>
