<?php
session_start();

// Verifica se o usuário está logado
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['status' => 'error', 'message' => 'Usuário não está logado']);
    exit();
}

$userId = $_SESSION['user_id'];
$followData = $_POST['follow_data'] ?? [];

if (empty($followData)) {
    echo json_encode(['status' => 'error', 'message' => 'Nenhum dado de follow fornecido']);
    exit();
}

// Conexão com o Banco de Dados
$host = 'localhost';
$db = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die(json_encode(['status' => 'error', 'message' => 'Erro na conexão com o banco de dados']));
}
$conn->set_charset("utf8mb4");

// Função para seguir ou deixar de seguir
$followType = $_POST['follow_type'] ?? null;
$followValue = $_POST['follow_value'] ?? null;
$action = $_POST['action'] ?? null;

if ($followType && $followValue && $action) {
    if ($action === 'follow') {
        // Verifica se já está seguindo
        $stmt = $conn->prepare("SELECT * FROM follows WHERE user_id = ? AND follow_type = ? AND follow_value = ?");
        $stmt->bind_param("iss", $userId, $followType, $followValue);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows === 0) {
            // Inserir o follow
            $stmt = $conn->prepare("INSERT INTO follows (user_id, follow_type, follow_value) VALUES (?, ?, ?)");
            $stmt->bind_param("iss", $userId, $followType, $followValue);
            if ($stmt->execute()) {
                echo json_encode(['status' => 'success', 'message' => 'Seguido com sucesso']);
            } else {
                echo json_encode(['status' => 'error', 'message' => 'Erro ao seguir']);
            }
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Já está seguindo']);
        }
    } elseif ($action === 'unfollow') {
        // Deixar de seguir
        $stmt = $conn->prepare("DELETE FROM follows WHERE user_id = ? AND follow_type = ? AND follow_value = ?");
        $stmt->bind_param("iss", $userId, $followType, $followValue);
        if ($stmt->execute()) {
            echo json_encode(['status' => 'success', 'message' => 'Deixou de seguir']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Erro ao deixar de seguir']);
        }
    }
    exit();
}

// Verificar estado de follow em lote (batch)
if (!empty($followData)) {
    $placeholders = [];
    $values = [];
    
    foreach ($followData as $item) {
        $placeholders[] = '(?, ?, ?)';
        $values[] = $userId;
        $values[] = $item['follow_type'];
        $values[] = $item['follow_value'];
    }

    $sql = "SELECT follow_type, follow_value, COUNT(*) AS is_following 
            FROM follows 
            WHERE user_id = ? AND (follow_type, follow_value) IN (" . implode(',', $placeholders) . ") 
            GROUP BY follow_type, follow_value";

    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        echo json_encode(['status' => 'error', 'message' => 'Erro na consulta']);
        exit();
    }

    $stmt->bind_param(str_repeat('iss', count($followData)), ...$values);
    $stmt->execute();
    $result = $stmt->get_result();

    $followStatuses = [];
    while ($row = $result->fetch_assoc()) {
        $followStatuses[] = [
            'follow_type' => $row['follow_type'],
            'follow_value' => $row['follow_value'],
            'is_following' => $row['is_following'] > 0
        ];
    }

    echo json_encode(['status' => 'success', 'follow_statuses' => $followStatuses]);
}
?>
