<?php
require_once __DIR__ . '/../config.php';

// api_comment_report.php
declare(strict_types=1);
session_start();
header('Content-Type: application/json; charset=utf-8');

$cfg = [
  'host' => 'localhost',
  'db'   => 'digupdog_FEED',
  'user' => 'digupdog_FEEDadmin',
  'pass' => 'Raimundinho1',
  'charset' => 'utf8mb4'
];

$raw = file_get_contents('php://input');
$js  = json_decode($raw, true) ?: [];

$cid   = isset($js['comment_id']) ? (int)$js['comment_id'] : 0;
$reason= trim($js['reason'] ?? 'report');

if ($cid <= 0) { echo json_encode(['success'=>false, 'error'=>'bad_comment']); exit; }

$mysqli = @new mysqli($cfg['host'], $cfg['user'], $cfg['pass'], $cfg['db']);
if ($mysqli->connect_error) { echo json_encode(['success'=>false, 'error'=>'db']); exit; }
$mysqli->set_charset($cfg['charset']);

$user_id = null;
if (!empty($_SESSION['username'])) {
  $u = $_SESSION['username'];
  $stmtU = $mysqli->prepare("SELECT id FROM user_myhashtag WHERE username=? LIMIT 1");
  $stmtU->bind_param('s', $u);
  if ($stmtU->execute()) { $idrow = $stmtU->get_result()->fetch_assoc(); if ($idrow) $user_id = (int)$idrow['id']; }
  $stmtU->close();
}
$uid = $user_id ? $user_id : null;

$stmt = $mysqli->prepare("INSERT INTO comment_reports (comment_id, user_id, reason, created_at) VALUES (?, ?, ?, NOW())");
$stmt->bind_param('iis', $cid, $uid, $reason);
$ok = $stmt->execute();
$stmt->close();

echo json_encode(['success'=>$ok], JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
