<?php
require_once __DIR__ . '/../config.php';

/**
 * File: api_shorten.php
 * GET ?url=https://...
 * -> { success: true, short_url: "https://SEU_DOMINIO/s/XXXXXX" }
 */
session_start();
header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store');

$host = 'localhost';
$db   = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=$charset", $user, $pass, [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);
} catch (PDOException $e) {
    http_response_code(500); echo json_encode(['success'=>false]); exit;
}

$raw = $_GET['url'] ?? '';
$url = filter_var($raw, FILTER_VALIDATE_URL);
if (!$url || !preg_match('~^https?://~i', $url)) { echo json_encode(['success'=>false]); exit; }

function base_url(): string {
    $sch = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
    $host= $_SERVER['HTTP_HOST'] ?? 'localhost';
    return $sch.'://'.$host;
}
function make_code(int $len=7): string {
    $alphabet = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
    $s = '';
    for ($i=0;$i<$len;$i++) $s .= $alphabet[random_int(0, strlen($alphabet)-1)];
    return $s;
}

// tenta código único
$code = null;
for ($i=0;$i<5;$i++) {
    $try = make_code();
    $st = $pdo->prepare("SELECT 1 FROM shortlinks WHERE code = ? LIMIT 1");
    $st->execute([$try]);
    if (!$st->fetch()) { $code = $try; break; }
}
if (!$code) { echo json_encode(['success'=>false]); exit; }

$st = $pdo->prepare("INSERT INTO shortlinks (code, target_url, created_at) VALUES (?, ?, NOW())");
$st->execute([$code, $url]);

echo json_encode(['success'=>true, 'short_url'=> base_url().'/s/'.$code]);
