# =====================================================
# FLOWB0T NEXUS - PowerShell Deployment Script
# Execute este script no Windows PowerShell
# =====================================================

Write-Host "========================================" -ForegroundColor Cyan
Write-Host "   FLOWB0T NEXUS - Auto Deploy" -ForegroundColor Cyan
Write-Host "========================================" -ForegroundColor Cyan
Write-Host ""

# Configuracoes do servidor
$SERVER = "159-100-13-177.cprapid.com"
$USER = "root"
$PASS = "Squatting-Refund1-Quantum"
$REMOTE_PATH = "/home/digupdog/public_html/flowb0t.com/nexus"
$LOCAL_PATH = $PSScriptRoot

Write-Host "Servidor: $SERVER" -ForegroundColor Yellow
Write-Host "Destino: $REMOTE_PATH" -ForegroundColor Yellow
Write-Host "Local: $LOCAL_PATH" -ForegroundColor Yellow
Write-Host ""

# Verificar se WinSCP esta instalado
$winscpPath = "C:\Program Files (x86)\WinSCP\WinSCP.com"
if (-not (Test-Path $winscpPath)) {
    Write-Host "WinSCP nao encontrado. Instalando via winget..." -ForegroundColor Yellow
    winget install WinSCP.WinSCP
    $winscpPath = "C:\Program Files (x86)\WinSCP\WinSCP.com"
}

# Script WinSCP
$winscpScript = @"
open sftp://${USER}:${PASS}@${SERVER}/
option confirm off
mkdir $REMOTE_PATH
mkdir $REMOTE_PATH/config
mkdir $REMOTE_PATH/core
mkdir $REMOTE_PATH/engine
mkdir $REMOTE_PATH/engine/SearchProviders
mkdir $REMOTE_PATH/engine/Processors
mkdir $REMOTE_PATH/engine/Workers
mkdir $REMOTE_PATH/engine/Filters
mkdir $REMOTE_PATH/models
mkdir $REMOTE_PATH/api
mkdir $REMOTE_PATH/ui
mkdir $REMOTE_PATH/ui/assets
mkdir $REMOTE_PATH/ui/assets/css
mkdir $REMOTE_PATH/ui/assets/js
mkdir $REMOTE_PATH/ui/assets/img
mkdir $REMOTE_PATH/ui/components
mkdir $REMOTE_PATH/ui/pages
mkdir $REMOTE_PATH/cli
mkdir $REMOTE_PATH/data
mkdir $REMOTE_PATH/logs
mkdir $REMOTE_PATH/logs/app
mkdir $REMOTE_PATH/logs/crawl
mkdir $REMOTE_PATH/logs/error
mkdir $REMOTE_PATH/logs/access
mkdir $REMOTE_PATH/exports
mkdir $REMOTE_PATH/temp
mkdir $REMOTE_PATH/sql
synchronize remote "$LOCAL_PATH" "$REMOTE_PATH" -mirror
chmod 755 $REMOTE_PATH
chmod 777 $REMOTE_PATH/logs
chmod 777 $REMOTE_PATH/logs/*
chmod 777 $REMOTE_PATH/exports
chmod 777 $REMOTE_PATH/temp
chmod 600 $REMOTE_PATH/.env
exit
"@

$scriptFile = "$env:TEMP\winscp_deploy.txt"
$winscpScript | Out-File -FilePath $scriptFile -Encoding ASCII

Write-Host "Iniciando deploy..." -ForegroundColor Green
& $winscpPath /script=$scriptFile /log="$env:TEMP\winscp_log.txt"

if ($LASTEXITCODE -eq 0) {
    Write-Host ""
    Write-Host "========================================" -ForegroundColor Green
    Write-Host "   DEPLOY CONCLUIDO COM SUCESSO!" -ForegroundColor Green
    Write-Host "========================================" -ForegroundColor Green
    Write-Host ""
    Write-Host "Acesse: https://flowb0t.com/nexus/" -ForegroundColor Cyan
    Write-Host ""
    Write-Host "PROXIMO PASSO: Executar o SQL no banco de dados" -ForegroundColor Yellow
    Write-Host "1. Acesse phpMyAdmin ou MySQL" -ForegroundColor White
    Write-Host "2. Execute o arquivo sql/schema.sql" -ForegroundColor White
} else {
    Write-Host "Erro no deploy. Verifique o log em: $env:TEMP\winscp_log.txt" -ForegroundColor Red
}

Remove-Item $scriptFile -ErrorAction SilentlyContinue
