-- =====================================================
-- FLOWB0T NEXUS - Existing Tables Analysis
-- Run this on the server to get table structures
-- =====================================================

-- 1. Show all tables in the database
SHOW TABLES;

-- 2. Get PINFEEDS table structure (main target for imports)
DESCRIBE pinfeeds;

-- 3. Get FEED_DATA table structure
DESCRIBE feed_data;

-- 4. Get USER_MYHASHTAG table structure
DESCRIBE user_myhashtag;

-- 5. Get CRAWLER_SEEN_LINKS table structure (if exists)
DESCRIBE crawler_seen_links;

-- 6. Statistics for existing tables
SELECT 'pinfeeds' as table_name, COUNT(*) as total_records FROM pinfeeds
UNION ALL
SELECT 'feed_data', COUNT(*) FROM feed_data
UNION ALL
SELECT 'user_myhashtag', COUNT(*) FROM user_myhashtag;

-- 7. Pinfeeds columns info
SELECT
    COLUMN_NAME,
    DATA_TYPE,
    CHARACTER_MAXIMUM_LENGTH,
    IS_NULLABLE,
    COLUMN_DEFAULT
FROM INFORMATION_SCHEMA.COLUMNS
WHERE TABLE_SCHEMA = 'digupdog_FEED'
AND TABLE_NAME = 'pinfeeds'
ORDER BY ORDINAL_POSITION;

-- 8. Check indexes on pinfeeds
SHOW INDEX FROM pinfeeds;

-- 9. Recent records in pinfeeds (to understand data format)
SELECT * FROM pinfeeds ORDER BY id DESC LIMIT 5;

-- 10. Sample data to understand structure
SELECT
    id,
    LEFT(title, 50) as title_sample,
    LEFT(link, 80) as link_sample,
    source_domain,
    author,
    pubDate
FROM pinfeeds
ORDER BY id DESC
LIMIT 10;
