#!/bin/bash
# Flowbot DCI - Parallel Worker Launcher
# Executa multiplos workers em paralelo

WORKER_PATH="/home/digupdog/public_html/digupdog.net/Flowb0t_DCI/v2/cli/worker.php"
PHP_BIN="/opt/cpanel/ea-php81/root/usr/bin/php"
MAX_WORKERS=3
LOG_DIR="/home/digupdog/public_html/digupdog.net/Flowb0t_DCI/v2/logs"

# Create log directory if not exists
mkdir -p "$LOG_DIR"

# Function to check if worker is running
is_worker_running() {
    pgrep -f "worker.php" | wc -l
}

# Get current worker count
CURRENT_WORKERS=$(is_worker_running)

# Launch workers if below max
if [ "$CURRENT_WORKERS" -lt "$MAX_WORKERS" ]; then
    WORKERS_TO_LAUNCH=$((MAX_WORKERS - CURRENT_WORKERS))

    for i in $(seq 1 $WORKERS_TO_LAUNCH); do
        WORKER_ID="worker_$(date +%s)_$i"
        nohup $PHP_BIN $WORKER_PATH > "$LOG_DIR/$WORKER_ID.log" 2>&1 &
        echo "Launched $WORKER_ID (PID: $!)"
    done
else
    echo "Max workers ($MAX_WORKERS) already running"
fi

# Show status
echo "Active workers: $(is_worker_running)"

