#!/bin/bash
# Flowbot DCI - Ultra Parallel Workers
# 10 workers para 32-core server

WORKER_PATH="/home/digupdog/public_html/digupdog.net/Flowb0t_DCI/v2/cli/worker.php"
PHP_BIN="/opt/cpanel/ea-php81/root/usr/bin/php"
MAX_WORKERS=10
LOG_DIR="/home/digupdog/public_html/digupdog.net/Flowb0t_DCI/v2/logs"
PID_FILE="/tmp/flowbot_workers.pid"

mkdir -p "$LOG_DIR"

# Count running workers
CURRENT_WORKERS=$(pgrep -f "worker.php" | wc -l)

# Launch if below max
if [ "$CURRENT_WORKERS" -lt "$MAX_WORKERS" ]; then
    WORKERS_TO_LAUNCH=$((MAX_WORKERS - CURRENT_WORKERS))

    for i in $(seq 1 $WORKERS_TO_LAUNCH); do
        WORKER_ID="w$(date +%s%N | cut -c1-13)_$i"
        nohup $PHP_BIN -d memory_limit=1024M $WORKER_PATH > "$LOG_DIR/$WORKER_ID.log" 2>&1 &
        echo "$!" >> "$PID_FILE"
        sleep 0.1
    done
    echo "Launched $WORKERS_TO_LAUNCH workers. Total: $(pgrep -f worker.php | wc -l)"
else
    echo "Max workers ($MAX_WORKERS) running"
fi

