<?php
/**
 * ===========================================
 * FLOWBOT DCI - SEARCH ENGINE INTERFACE
 * ===========================================
 * Common interface for all search engine adapters
 */

declare(strict_types=1);

namespace FlowbotDCI\Services\SearchEngine;

interface SearchEngineInterface
{
    /**
     * Get the name of the search engine
     */
    public function getName(): string;

    /**
     * Check if the engine is available/configured
     */
    public function isAvailable(): bool;

    /**
     * Search for a query and return results
     *
     * @param string $query Search query
     * @param int $maxResults Maximum results to return
     * @param int $offset Pagination offset
     * @return array Array of search results ['url' => string, 'title' => string, 'snippet' => string]
     */
    public function search(string $query, int $maxResults = 10, int $offset = 0): array;

    /**
     * Get the last error message if any
     */
    public function getLastError(): ?string;
}
