# Flowbot DCI v2.0

**Sistema profissional de processamento em lote de URLs com extração automática de metadados**

## Visão Geral

Flowbot DCI é uma ferramenta de web scraping que processa múltiplas URLs em paralelo, extrai metadados (título, descrição, imagens, etc.) e armazena os dados em um banco de dados MySQL.

### Características Principais

- **Processamento em 4 Fases** - Sistema adaptativo com retry automático
- **Alta Concorrência** - Até 100 requisições simultâneas
- **Extração Inteligente** - Metadados, Open Graph, Twitter Cards, favicons
- **Interface em Tempo Real** - Progresso visual com barras e terminal
- **Geração de Embeds** - YouTube, Vimeo, TikTok, e mais
- **Arquitetura Modular** - Código organizado e profissional

## Estrutura do Projeto

```
v2/
├── config/
│   └── config.php          # Configurações principais
├── public/
│   ├── index.php           # Entry point
│   └── assets/
│       ├── css/style.css   # Estilos
│       └── js/app.js       # JavaScript
├── src/
│   ├── autoload.php        # PSR-4 Autoloader
│   ├── Core/
│   │   ├── Application.php # Classe principal
│   │   └── Database.php    # Conexão PDO
│   ├── Services/
│   │   ├── WebScraper.php          # Requisições HTTP paralelas
│   │   ├── MetadataExtractor.php   # Extração de metadados
│   │   ├── ProgressTracker.php     # Rastreamento de progresso
│   │   ├── EmbedGenerator.php      # Gerador de embeds
│   │   └── UrlProcessor.php        # Processador principal
│   ├── Models/
│   │   ├── PinFeed.php     # Model de feeds
│   │   ├── FeedData.php    # Model de dados de feed
│   │   └── User.php        # Model de usuários
│   └── Utils/
│       ├── AuthorGenerator.php     # Gerador de autores
│       └── TagExtractor.php        # Extrator de tags
├── views/
│   ├── form.php            # Formulário de entrada
│   └── progress.php        # Página de progresso
├── temp/                   # Arquivos temporários
├── .env                    # Configuração de ambiente
├── .env.example            # Exemplo de configuração
├── .gitignore              # Arquivos ignorados pelo Git
└── README.md               # Este arquivo
```

## Instalação

### Requisitos

- PHP 7.4 ou superior
- Extensões PHP: PDO, cURL, DOM, JSON, mbstring
- MySQL 5.7 ou superior
- Servidor web (Apache/Nginx)

### Passos

1. **Clone ou copie os arquivos**
   ```bash
   cp -r v2 /var/www/flowbot-dci
   ```

2. **Configure o ambiente**
   ```bash
   cd /var/www/flowbot-dci
   cp .env.example .env
   nano .env
   ```

3. **Edite o arquivo `.env`**
   ```env
   DB_HOST=localhost
   DB_NAME=seu_banco
   DB_USER=seu_usuario
   DB_PASSWORD=sua_senha
   ```

4. **Configure o servidor web**

   **Apache (.htaccess em public/)**
   ```apache
   RewriteEngine On
   RewriteCond %{REQUEST_FILENAME} !-f
   RewriteCond %{REQUEST_FILENAME} !-d
   RewriteRule ^ index.php [L]
   ```

   **Nginx**
   ```nginx
   location / {
       try_files $uri $uri/ /index.php?$query_string;
   }
   ```

5. **Defina permissões**
   ```bash
   chmod -R 755 temp/
   chmod 644 .env
   ```

6. **Acesse no navegador**
   ```
   http://seu-servidor/public/
   ```

## Uso

1. Acesse a interface web
2. Cole as URLs no textarea (uma por linha)
3. Clique em "Start Processing"
4. Acompanhe o progresso em tempo real

## Sistema de 4 Fases

| Fase | Concorrência | Timeout | Descrição |
|------|--------------|---------|-----------|
| 0 | 100 | 1s | Ultra-rápido, tenta primeiro |
| 1 | 60 | 2s | Retry de falhas da fase 0 |
| 2 | 30 | 5s | Retry com mais paciência |
| 3 | 10 | 10s | Última tentativa, lento |

URLs que falham em uma fase são automaticamente movidas para a próxima.

## Configuração

### Variáveis de Ambiente (.env)

```env
# Banco de Dados
DB_HOST=localhost
DB_NAME=digupdog_FEED
DB_USER=seu_usuario
DB_PASSWORD=sua_senha

# Aplicação
APP_DEBUG=false          # true para desenvolvimento
APP_TIMEZONE=America/Sao_Paulo

# Processamento
PHASE_0_CONCURRENCY=100  # Requisições simultâneas fase 0
PHASE_0_TIMEOUT=1        # Timeout em segundos fase 0
MAX_LINKS_PER_BATCH=10   # Links por iteração

# Segurança
SSL_VERIFY=true          # Verificar certificados SSL
```

## Desenvolvimento

### Adicionar nova fonte de embed

Edite `src/Services/EmbedGenerator.php`:

```php
case 'novaplataforma.com':
    return $this->novaPlataformaEmbed($url);
```

### Adicionar novo extrator de metadados

Edite `src/Services/MetadataExtractor.php` e adicione queries XPath.

### Customizar interface

Edite os arquivos em `views/` e `public/assets/`.

## Segurança

- **Credenciais**: Sempre use `.env` (nunca hardcode)
- **SSL**: Mantenha `SSL_VERIFY=true` em produção
- **Permissões**: Restrinja acesso ao diretório `temp/`
- **Validação**: URLs são validadas antes do processamento

## Troubleshooting

### Erro de conexão com banco
- Verifique credenciais no `.env`
- Confirme que o banco existe
- Teste conexão: `mysql -u usuario -p banco`

### URLs não são processadas
- Verifique extensão cURL: `php -m | grep curl`
- Teste conectividade: `curl -I URL`
- Aumente timeout no `.env`

### Erro de permissão
- Verifique permissões do diretório `temp/`
- Execute: `chmod -R 755 temp/`

## Licença

Uso interno - Todos os direitos reservados.

---

**Versão**: 2.0.0
**Última atualização**: 2026-01-17
