#!/bin/bash
# Flowbot DCI - MAXIMUM Parallel Workers (20)

WORKER_PATH="/home/digupdog/public_html/digupdog.net/Flowb0t_DCI/v2/cli/worker.php"
PHP_BIN="/opt/cpanel/ea-php81/root/usr/bin/php"
MAX_WORKERS=20
LOG_DIR="/home/digupdog/public_html/digupdog.net/Flowb0t_DCI/v2/logs"

mkdir -p "$LOG_DIR"

CURRENT=$(pgrep -f "worker.php" | wc -l)

if [ "$CURRENT" -lt "$MAX_WORKERS" ]; then
    LAUNCH=$((MAX_WORKERS - CURRENT))
    for i in $(seq 1 $LAUNCH); do
        nohup $PHP_BIN -d memory_limit=2048M $WORKER_PATH > "$LOG_DIR/w_$(date +%s%N)_$i.log" 2>&1 &
        sleep 0.05
    done
    echo "Launched $LAUNCH workers. Total: $(pgrep -f worker.php | wc -l)"
fi

