<?php
/**
 * ============================================
 * FLOWBOT DCI - UNIFIED CRAWLER VIEW v7.0
 * ============================================
 * Modern dark theme dashboard for unified crawling
 * ============================================
 */

$pageTitle = 'Unified Crawler';
$pageDescription = 'Professional web crawler with search, deep crawl, and sitemap support';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($pageTitle) ?> - Flowb0t DCI v7.0</title>
    <link rel="stylesheet" href="/Flowb0t_DCI/v2/public/assets/css/v7-crawler.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&family=JetBrains+Mono:wght@400;500&display=swap" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>
    <div class="app-container">
        <!-- Header -->
        <header class="app-header">
            <div class="header-left">
                <h1 class="app-logo">
                    <span class="logo-icon">🚀</span>
                    Flowb0t <span class="version">v7.0</span>
                </h1>
                <nav class="main-nav">
                    <a href="/Flowb0t_DCI/v2/public/" class="nav-link">Dashboard</a>
                    <a href="/Flowb0t_DCI/v2/public/new" class="nav-link">Link Processor</a>
                    <a href="/Flowb0t_DCI/v2/public/crawler/unified" class="nav-link active">Unified Crawler</a>
                    <a href="/Flowb0t_DCI/v2/public/history" class="nav-link">History</a>
                </nav>
            </div>
            <div class="header-right">
                <span class="status-badge online">System Online</span>
            </div>
        </header>

        <!-- Main Content -->
        <main class="main-content">
            <div class="content-grid">
                <!-- Left Column: Input Form -->
                <section class="panel input-panel">
                    <div class="panel-header">
                        <h2 class="panel-title">
                            <span class="icon">🔍</span>
                            Crawler Configuration
                        </h2>
                    </div>
                    <div class="panel-body">
                        <form id="crawlerForm" class="crawler-form">
                            <!-- Mode Selection -->
                            <div class="form-group">
                                <label class="form-label">Crawl Mode</label>
                                <div class="mode-selector">
                                    <button type="button" class="mode-btn active" data-mode="search">
                                        <span class="mode-icon">🔎</span>
                                        <span class="mode-name">Search</span>
                                    </button>
                                    <button type="button" class="mode-btn" data-mode="deep">
                                        <span class="mode-icon">🕸️</span>
                                        <span class="mode-name">Deep Crawl</span>
                                    </button>
                                    <button type="button" class="mode-btn" data-mode="sitemap">
                                        <span class="mode-icon">🗺️</span>
                                        <span class="mode-name">Sitemap</span>
                                    </button>
                                    <button type="button" class="mode-btn" data-mode="hybrid">
                                        <span class="mode-icon">⚡</span>
                                        <span class="mode-name">Hybrid</span>
                                    </button>
                                </div>
                                <input type="hidden" name="mode" id="crawlMode" value="search">
                            </div>

                            <!-- Search Terms (for search/hybrid mode) -->
                            <div class="form-group" id="searchTermsGroup">
                                <label class="form-label" for="searchTerms">Search Terms</label>
                                <textarea
                                    id="searchTerms"
                                    name="search_terms"
                                    class="form-textarea"
                                    rows="3"
                                    placeholder="Enter search terms (one per line)&#10;Example:&#10;web scraping tutorials&#10;python crawler guide"
                                ></textarea>
                                <span class="form-hint">Enter keywords or phrases to search across multiple engines</span>
                            </div>

                            <!-- Seed URLs (for deep/sitemap/hybrid mode) -->
                            <div class="form-group" id="seedUrlsGroup" style="display:none;">
                                <label class="form-label" for="seedUrls">Seed URLs</label>
                                <textarea
                                    id="seedUrls"
                                    name="seed_urls"
                                    class="form-textarea"
                                    rows="3"
                                    placeholder="Enter URLs to crawl (one per line)&#10;Example:&#10;https://example.com&#10;https://blog.example.org"
                                ></textarea>
                                <span class="form-hint">Starting points for crawling</span>
                            </div>

                            <!-- Search Engines -->
                            <div class="form-group" id="searchEnginesGroup">
                                <label class="form-label">Search Engines</label>
                                <div class="chip-group">
                                    <label class="chip active">
                                        <input type="checkbox" name="engines[]" value="bing" checked>
                                        <span class="chip-icon">🔵</span> Bing
                                    </label>
                                    <label class="chip active">
                                        <input type="checkbox" name="engines[]" value="yahoo" checked>
                                        <span class="chip-icon">🟣</span> Yahoo
                                    </label>
                                    <label class="chip active">
                                        <input type="checkbox" name="engines[]" value="duckduckgo" checked>
                                        <span class="chip-icon">🦆</span> DuckDuckGo
                                    </label>
                                    <label class="chip">
                                        <input type="checkbox" name="engines[]" value="searxng">
                                        <span class="chip-icon">🔗</span> SearXNG
                                    </label>
                                </div>
                            </div>

                            <!-- Advanced Options Toggle -->
                            <div class="form-group">
                                <button type="button" class="toggle-advanced" id="toggleAdvanced">
                                    <span class="toggle-icon">⚙️</span>
                                    Advanced Options
                                    <span class="chevron">▼</span>
                                </button>
                            </div>

                            <!-- Advanced Options Panel -->
                            <div class="advanced-options" id="advancedOptions" style="display:none;">
                                <div class="options-grid">
                                    <div class="form-group">
                                        <label class="form-label" for="maxPages">Max Pages</label>
                                        <input type="number" id="maxPages" name="max_pages" class="form-input" value="100" min="1" max="10000">
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label" for="maxDepth">Max Depth</label>
                                        <input type="number" id="maxDepth" name="max_depth" class="form-input" value="3" min="0" max="10">
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label" for="parallelCount">Parallel Requests</label>
                                        <input type="number" id="parallelCount" name="parallel_count" class="form-input" value="5" min="1" max="50">
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label" for="timeout">Timeout (sec)</label>
                                        <input type="number" id="timeout" name="timeout" class="form-input" value="10" min="1" max="60">
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="form-label" for="relevanceThreshold">
                                        Relevance Threshold: <span id="relevanceValue">2.0</span>
                                    </label>
                                    <input type="range" id="relevanceThreshold" name="relevance_threshold"
                                           class="form-range" min="0" max="20" step="0.5" value="2">
                                </div>

                                <div class="form-group">
                                    <label class="form-label">Options</label>
                                    <div class="checkbox-group">
                                        <label class="checkbox-label">
                                            <input type="checkbox" name="same_domain_only" checked>
                                            <span class="checkmark"></span>
                                            Same domain only
                                        </label>
                                        <label class="checkbox-label">
                                            <input type="checkbox" name="respect_robots" checked>
                                            <span class="checkmark"></span>
                                            Respect robots.txt
                                        </label>
                                        <label class="checkbox-label">
                                            <input type="checkbox" name="infinite_mode">
                                            <span class="checkmark"></span>
                                            Infinite mode
                                        </label>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="form-label" for="blockedDomains">Blocked Domains</label>
                                    <textarea
                                        id="blockedDomains"
                                        name="blocked_domains"
                                        class="form-textarea small"
                                        rows="2"
                                        placeholder="facebook.com&#10;twitter.com"
                                    ></textarea>
                                </div>

                                <div class="form-group">
                                    <label class="form-label" for="forcedDomains">Forced Domains (bypass relevance)</label>
                                    <textarea
                                        id="forcedDomains"
                                        name="forced_domains"
                                        class="form-textarea small"
                                        rows="2"
                                        placeholder="trusted-source.com"
                                    ></textarea>
                                </div>
                            </div>

                            <!-- Action Buttons -->
                            <div class="form-actions">
                                <button type="submit" class="btn btn-primary btn-lg" id="startBtn">
                                    <span class="btn-icon">▶</span>
                                    Start Crawl
                                </button>
                                <button type="button" class="btn btn-secondary" id="pauseBtn" disabled>
                                    <span class="btn-icon">⏸</span>
                                    Pause
                                </button>
                                <button type="button" class="btn btn-danger" id="stopBtn" disabled>
                                    <span class="btn-icon">⏹</span>
                                    Stop
                                </button>
                            </div>
                        </form>
                    </div>
                </section>

                <!-- Right Column: Progress & Stats -->
                <section class="panel progress-panel">
                    <div class="panel-header">
                        <h2 class="panel-title">
                            <span class="icon">📊</span>
                            Progress
                        </h2>
                        <span class="job-id" id="currentJobId">-</span>
                    </div>
                    <div class="panel-body">
                        <!-- Progress Ring -->
                        <div class="progress-ring-container">
                            <svg class="progress-ring" viewBox="0 0 120 120">
                                <circle class="progress-ring-bg" cx="60" cy="60" r="54" />
                                <circle class="progress-ring-fill" cx="60" cy="60" r="54"
                                        stroke-dasharray="339.292" stroke-dashoffset="339.292" />
                            </svg>
                            <div class="progress-text">
                                <span class="progress-value" id="progressValue">0</span>
                                <span class="progress-unit">%</span>
                            </div>
                        </div>

                        <!-- Stats Grid -->
                        <div class="stats-grid">
                            <div class="stat-card">
                                <span class="stat-value" id="statProcessed">0</span>
                                <span class="stat-label">Processed</span>
                            </div>
                            <div class="stat-card success">
                                <span class="stat-value" id="statImported">0</span>
                                <span class="stat-label">Imported</span>
                            </div>
                            <div class="stat-card warning">
                                <span class="stat-value" id="statIgnored">0</span>
                                <span class="stat-label">Ignored</span>
                            </div>
                            <div class="stat-card error">
                                <span class="stat-value" id="statErrors">0</span>
                                <span class="stat-label">Errors</span>
                            </div>
                        </div>

                        <!-- Time Stats -->
                        <div class="time-stats">
                            <div class="time-stat">
                                <span class="time-label">Elapsed</span>
                                <span class="time-value" id="elapsedTime">00:00:00</span>
                            </div>
                            <div class="time-stat">
                                <span class="time-label">ETA</span>
                                <span class="time-value" id="etaTime">--:--:--</span>
                            </div>
                            <div class="time-stat">
                                <span class="time-label">Rate</span>
                                <span class="time-value"><span id="processingRate">0</span> /s</span>
                            </div>
                        </div>

                        <!-- Status Badge -->
                        <div class="status-container">
                            <span class="status-indicator" id="statusIndicator">
                                <span class="status-dot"></span>
                                <span class="status-text">Ready</span>
                            </span>
                        </div>
                    </div>
                </section>

                <!-- Bottom Row: Logs and Domain Stats -->
                <section class="panel logs-panel">
                    <div class="panel-header">
                        <h2 class="panel-title">
                            <span class="icon">📜</span>
                            Live Logs
                        </h2>
                        <div class="log-filters">
                            <button class="filter-btn active" data-filter="all">All</button>
                            <button class="filter-btn" data-filter="success">Success</button>
                            <button class="filter-btn" data-filter="warning">Warning</button>
                            <button class="filter-btn" data-filter="error">Error</button>
                        </div>
                    </div>
                    <div class="panel-body">
                        <div class="terminal" id="logTerminal">
                            <div class="terminal-content" id="logContent">
                                <div class="log-line info">
                                    <span class="log-time">[--:--:--]</span>
                                    <span class="log-msg">Ready to start crawling...</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

                <section class="panel domains-panel">
                    <div class="panel-header">
                        <h2 class="panel-title">
                            <span class="icon">🌐</span>
                            Domain Statistics
                        </h2>
                    </div>
                    <div class="panel-body">
                        <div class="chart-container">
                            <canvas id="domainsChart"></canvas>
                        </div>
                        <div class="domains-table-container">
                            <table class="domains-table" id="domainsTable">
                                <thead>
                                    <tr>
                                        <th>Domain</th>
                                        <th>Visits</th>
                                        <th>Success</th>
                                        <th>Rate</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr class="empty-row">
                                        <td colspan="4">No domain data yet</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </section>
            </div>
        </main>

        <!-- Footer -->
        <footer class="app-footer">
            <span>Flowb0t DCI v7.0 - Unified Professional Crawler</span>
            <span class="memory-usage">Memory: <span id="memoryUsage">0</span> MB</span>
        </footer>
    </div>

    <!-- Toast Container -->
    <div class="toast-container" id="toastContainer"></div>

    <script src="/Flowb0t_DCI/v2/public/assets/js/crawler-unified.js"></script>
</body>
</html>
