<?php
/**
 * ============================================
 * FLOWBOT DCI v3.0 - BASE LAYOUT TEMPLATE
 * ============================================
 * All views extend this layout for consistency
 */
declare(strict_types=1);

// Calculate base URL
$baseUrl = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\');

// Default page variables
$pageTitle = $pageTitle ?? 'Flowb0t DCI';
$currentPage = $currentPage ?? 'dashboard';
$processId = $processId ?? null;

// Ensure stats has defaults
$stats = $stats ?? [
    'active' => 0,
    'completed' => 0,
    'failed' => 0,
    'today' => 0,
    'total_urls' => 0,
    'total_processes' => 0,
    'success_rate' => 0,
    'avg_processing_time' => 0
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($pageTitle) ?> - Flowb0t DCI v3.0</title>

    <!-- Favicon -->
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml,<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 32 32'><rect width='32' height='32' rx='8' fill='%233B82F6'/><path d='M8 10h16M8 16h12M8 22h8' stroke='white' stroke-width='2.5' stroke-linecap='round'/></svg>">

    <!-- Main CSS -->
    <link rel="stylesheet" href="<?= $baseUrl ?>/assets/css/v3-styles.css?v=<?= time() ?>">

    <!-- Page-specific CSS -->
    <?php if (isset($pageStyles)): ?>
    <style><?= $pageStyles ?></style>
    <?php endif; ?>
</head>
<body>
    <!-- Main Navigation -->
    <nav class="main-nav">
        <div class="nav-container">
            <!-- Brand -->
            <div class="nav-brand">
                <a href="<?= $baseUrl ?>/" class="brand-link">
                    <span class="brand-logo">
                        <svg viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <rect width="32" height="32" rx="8" fill="url(#brand-gradient)"/>
                            <path d="M8 10h16M8 16h12M8 22h8" stroke="white" stroke-width="2.5" stroke-linecap="round"/>
                            <circle cx="24" cy="22" r="4" fill="#10B981"/>
                            <defs>
                                <linearGradient id="brand-gradient" x1="0" y1="0" x2="32" y2="32">
                                    <stop stop-color="#3B82F6"/>
                                    <stop offset="1" stop-color="#8B5CF6"/>
                                </linearGradient>
                            </defs>
                        </svg>
                    </span>
                    <span class="brand-text">Flowb0t DCI</span>
                    <span class="brand-version">v3.0</span>
                </a>
            </div>

            <!-- Main Navigation Links -->
            <div class="nav-main">
                <a href="<?= $baseUrl ?>/" class="nav-link <?= $currentPage === 'dashboard' ? 'active' : '' ?>">
                    <svg class="nav-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <rect x="3" y="3" width="7" height="7" rx="1"/>
                        <rect x="14" y="3" width="7" height="7" rx="1"/>
                        <rect x="3" y="14" width="7" height="7" rx="1"/>
                        <rect x="14" y="14" width="7" height="7" rx="1"/>
                    </svg>
                    <span>Dashboard</span>
                </a>
                <a href="<?= $baseUrl ?>/new" class="nav-link <?= $currentPage === 'new' || $currentPage === 'form' ? 'active' : '' ?>">
                    <svg class="nav-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <circle cx="12" cy="12" r="9"/>
                        <line x1="12" y1="8" x2="12" y2="16"/>
                        <line x1="8" y1="12" x2="16" y2="12"/>
                    </svg>
                    <span>New Process</span>
                </a>
                <a href="<?= $baseUrl ?>/history" class="nav-link <?= $currentPage === 'history' ? 'active' : '' ?>">
                    <svg class="nav-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <circle cx="12" cy="12" r="9"/>
                        <polyline points="12,7 12,12 16,14"/>
                    </svg>
                    <span>History</span>
                </a>
                <a href="<?= $baseUrl ?>/settings" class="nav-link <?= $currentPage === 'settings' ? 'active' : '' ?>">
                    <svg class="nav-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <circle cx="12" cy="12" r="3"/>
                        <path d="M12 1v4M12 19v4M4.22 4.22l2.83 2.83M16.95 16.95l2.83 2.83M1 12h4M19 12h4M4.22 19.78l2.83-2.83M16.95 7.05l2.83-2.83"/>
                    </svg>
                    <span>Settings</span>
                </a>
            </div>

            <!-- Right Side -->
            <div class="nav-right">
                <a href="<?= $baseUrl ?>/new" class="btn btn-primary btn-sm">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" width="16" height="16">
                        <line x1="12" y1="5" x2="12" y2="19"/>
                        <line x1="5" y1="12" x2="19" y2="12"/>
                    </svg>
                    New
                </a>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main class="main-content">
        <?php if (isset($content)): ?>
            <?= $content ?>
        <?php endif; ?>
    </main>

    <!-- Main JavaScript -->
    <script src="<?= $baseUrl ?>/assets/js/app.js?v=<?= time() ?>"></script>
    <script src="<?= $baseUrl ?>/assets/js/realtime.js?v=<?= time() ?>"></script>

    <!-- Page-specific JavaScript -->
    <?php if (isset($pageScripts)): ?>
    <script><?= $pageScripts ?></script>
    <?php endif; ?>
</body>
</html>
