<?php
session_start();

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Conexão com o Banco de Dados
$host = 'localhost';
$db = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die("Erro na conexão com o banco de dados: " . $conn->connect_error);
}

function getAuthorAvatarByUsername($username, $conn) {
    $username = $conn->real_escape_string($username);
    $query = "SELECT thumbnail FROM pinfeeds WHERE author = '$username' ORDER BY pubDate DESC LIMIT 1";
    $result = $conn->query($query);
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        return $row['thumbnail'];
    } else {
        return false;
    }
}

// Parte para exibir tags
$tagsFile = 'tags.json';
$tags = file_exists($tagsFile) ? json_decode(file_get_contents($tagsFile), true) : [];
shuffle($tags); // Embaralha as tags
$randomTags = array_slice($tags, 0, 12); // Pega 12 tags aleatórias
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>DigUpDOG.com</title>
    <meta id="base-url" content="https://digupdog.com/">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet">


    <link href="styles.css" rel="stylesheet" type="text/css">
    <!-- Scripts Externos -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script async src="https://static.addtoany.com/menu/page.js"></script>
</head>
<body>

<div class="header-content">

<div class="search-bar">
    <button class="home-button"><i class="fas fa-hashtag"></i></button>
    <button class="menu-button"><i class="fas fa-bars menu-icon"></i></button>
    <input id="search-query" placeholder="#..." type="text" />
    <button id="search-button">
        <i class="fas fa-search search-icon"></i>
    </button>
    <a class="button pin" id="addPinButton" href="https://digupdog.com/aaa1.php" target="_self"><i class="fas fa-plus"></i></a>
</div>
    
<div id="side-menu" class="side-menu">
    <!-- Conteúdo do menu aqui -->
    <a href="#">Link 1</a>
    <a href="#">Link 2</a>
    <!-- Mais links do menu -->
</div>


<!-- Overlay -->
<div class="overlay"></div>

<div class="category-buttons-container">
<div class="category-buttons">
<div class="left-arrow"></div>

<div class="category-buttons-wrapper"><a class="category-button pins" href="https://digupdog.com" target="_self">Pins</a> <a class="category-button all" href="https://digupdog.com/all.php" target="_self">All</a> <a class="category-button world-news" href="https://digupdog.net/FEED/news.html" target="_self">World News</a> <a class="category-button entertainment" href="https://digupdog.net/FEED/entertainment.html" target="_self">Entertainment</a> <a class="category-button sports" href="https://digupdog.net/FEED/sports.html" target="_self">Sports</a> <a class="category-button videogames" href="https://digupdog.net/FEED/videogames.html" target="_self">Video Games</a> <a class="category-button plus" href="https://digupdog.com/plus.php" target="_self">18+</a></div>

<div class="right-arrow"></div>
</div></div>




<!-- Login/Register Section or Welcome Message -->
<div class="container"></div>
<div class="login-register-section" id="loginSection">
    <?php
    // Verifica se o usuário está logado
    if (isset($_SESSION['username'])) {
        $username = htmlspecialchars($_SESSION['username']);

        // Chama a função com ambos os parâmetros
        $authorAvatar = getAuthorAvatarByUsername($username, $conn);

        // Exiba o nome do autor como um link para o perfil
        echo "<a href='perfil.php?autor=$username'>";
        if ($authorAvatar !== false) {
            echo "<img src='$authorAvatar' alt='Avatar' class='author-avatar' style='width: 20px; height: 20px; margin-right: 5px; border: 2px solid black; border-radius: 20px; vertical-align: middle;'>";
        }
        echo "@" . $username . "</a>"; // Adicionando "@" antes do nome do usuário

        // Ícone de logout
        echo "<a href='logout.php'><i class='fas fa-sign-out-alt'></i></a>";
    } else {
        // Usuário não está logado
        echo "<a href='login.html'><i class='fas fa-sign-in-alt'></i></a>";
        echo "<a href='register.html'><i class='fas fa-user-plus'></i></a>";
    }
    ?>
</div>

</div>

    <!-- Tags Container -->
<div id="tags-container" style="margin-top: 2px;">
    <?php foreach ($randomTags as $tag): ?>
        <a href="#" class="tag-link tag-search-link" data-tag="<?php echo htmlspecialchars($tag); ?>">#<?php echo htmlspecialchars($tag); ?></a>
    <?php endforeach; ?>
    <a href="#" id="reload-tags" title="Recarregar tags"><i class="fas fa-sync-alt"></i></a> <!-- Ícone de recarregamento -->
</div>

<div class="result-list" id="feeds"></div>

<p>
    <button id="myBtn" onclick="topFunction()" title="Go to top">
        <i class="fas fa-arrow-up"></i>
    </button>
</p>


<footer>Beta 6.0</footer>
</div>
<!-- Scripts Pr車prios --><script src="https://digupdog.com/utils.js"></script><script src="https://digupdog.com/feeds.js"></script><script src="https://digupdog.com/search.js"></script><script src="https://digupdog.com/ui.js"></script><script src="https://digupdog.com/main.js"></script><script src="https://digupdog.com/all_loadfeeds.js"></script>

<script>

        $(document).ready(function() {
            $('.tag-link').click(function(e) {
                e.preventDefault();
                var tag = $(this).text().substr(1); // Remove o '#'
                $('#search-query').val(tag);
                // Implemente a lógica de busca aqui
            });
        });
    document.getElementById('addPinButton').addEventListener('click', function(e) {
        <?php if (!isset($_SESSION['username'])): ?>
            e.preventDefault(); // Impede o redirecionamento padrão
            window.location.href = 'login.html'; // Redireciona para a página de login
        <?php endif; ?>
    });
    
window.addEventListener('scroll', function() {
    var loginSection = document.querySelector('.login-register-section');
    var scrollPosition = window.scrollY;
    var categoryButtons = document.querySelector('.category-buttons-container');

    if (scrollPosition > 100) { // Defina a posição de rolamento desejada aqui
        loginSection.style.position = 'fixed';
        loginSection.style.bottom = '10px'; // Ajuste conforme necessário
        loginSection.style.left = '10px'; // Ajuste conforme necessário
        loginSection.style.zIndex = '50'; // Certifique-se de que o elemento esteja sempre em primeiro plano
        categoryButtons.style.marginBottom = loginSection.offsetHeight + 'px'; // Ajuste o espaço abaixo dos botões de categoria
    } else {
        loginSection.style.position = 'static'; // Deixa o elemento no fluxo normal
        categoryButtons.style.marginBottom = '0'; // Restaura o espaço abaixo dos botões de categoria
    }
});

document.addEventListener('DOMContentLoaded', function() {
    var tagElements = document.querySelectorAll('.tag-link');

    tagElements.forEach(function(tagElement) {
        // Colorindo as tags
        var tagText = tagElement.dataset.tag;
        var bgColor = stringToColor(tagText); // função definida em utils.js
        var textColor = isColorDark(bgColor) ? 'white' : 'black'; // função definida em utils.js

        // Aplica os estilos
        tagElement.style.backgroundColor = bgColor;
        tagElement.style.color = textColor;
        tagElement.style.border = '2px solid black';
        tagElement.style.padding = '5px 10px';
        tagElement.style.marginRight = '5px';
        tagElement.style.borderRadius = '5px';
        tagElement.style.textDecoration = 'none';
        tagElement.style.display = 'inline-block';
        tagElement.style.marginBottom = '5px';
        tagElement.style.fontWeight = 'bold';

        // Adicionando evento de clique para realizar a busca
        tagElement.addEventListener('click', function(e) {
            e.preventDefault(); // Impede o comportamento padrão do link
            var tag = this.dataset.tag; // Obtém a tag do atributo data-tag
            $('#search-query').val(tag); // Define o valor no campo de busca
            clearResults(); // Limpa resultados anteriores
            performSearch(); // Chama a função de busca
        });
    });
});

// Certifique-se de que as funções performSearch e clearResults estão definidas
function clearResults() {
    $('#feeds').empty();
}

$(document).ready(function() {
    // Restante do seu código...

    // Delegação de evento de clique para o botão de recarregamento
    $(document).on('click', '#reload-tags', function(e) {
        e.preventDefault();
        reloadTags();
    });

    // Função para recarregar tags
    function reloadTags() {
        $.ajax({
            url: 'tags.json', // Certifique-se de que este é o caminho correto
            method: 'GET',
            dataType: 'json',
            success: function(response) {
                updateTags(response);
            }
        });
    }

    // Função para atualizar as tags no contêiner
    function updateTags(tags) {
        var container = $('#tags-container');
        container.empty(); // Limpa as tags existentes

        // Embaralha e limita o array de tags
        shuffleArray(tags);
        var limitedTags = tags.slice(0, 12);

        // Adiciona novas tags ao contêiner
        limitedTags.forEach(function(tag) {
            var tagElement = $('<a href="#" class="tag-link tag-search-link" data-tag="' + tag + '">#' + tag + '</a>');
            
            // Aplica a coloração
            var bgColor = stringToColor(tag); // Assegure-se de que estas funções existem em utils.js
            var textColor = isColorDark(bgColor) ? 'white' : 'black';

                        tagElement.css({
                'backgroundColor': bgColor,
                'color': textColor,
                'border': '2px solid black',
                'padding': '3px 3px',
                'marginRight': '5px',
                'borderRadius': '5px',
                'textDecoration': 'none',
                'display': 'inline-block',
                'marginBottom': '5px',
                'fontWeight': 'bold'
            });

            container.append(tagElement);
        });

        // Adiciona o ícone de recarregamento novamente
        container.append('<a href="#" id="reload-tags" title="Recarregar tags"><i class="fas fa-sync-alt"></i></a>');
    }

    // Função para embaralhar um array
    function shuffleArray(array) {
        for (var i = array.length - 1; i > 0; i--) {
            var j = Math.floor(Math.random() * (i + 1));
            var temp = array[i];
            array[i] = array[j];
            array[j] = temp;
        }
    }

    // Chamar reloadTags na inicialização para carregar as tags inicialmente
    reloadTags();
});



document.querySelector('.menu-button').addEventListener('click', function() {
    let icon = this.querySelector('.menu-icon');
    let sideMenu = document.querySelector('.side-menu');
    let overlay = document.querySelector('.overlay');

    if (sideMenu.style.width === '30%' || sideMenu.style.width === '95%') {
        sideMenu.style.width = '0';
        overlay.style.display = 'none';
        document.body.style.overflow = 'auto';
        this.classList.remove('open');
        icon.classList.remove('fa-times');
        icon.classList.add('fa-bars');
    } else {
        sideMenu.style.width = window.innerWidth <= 768 ? '95%' : '30%';
        overlay.style.display = 'block';
        document.body.style.overflow = 'hidden';
        this.classList.add('open');
        icon.classList.remove('fa-bars');
        icon.classList.add('fa-times');
    }
});

// Adicione o evento de clique para o botão home para recarregar a página
document.querySelector('.home-button').addEventListener('click', function() {
    window.location.reload();
});


</script>

</body>
</html>