<?php
session_start();

// Verifica se o usuário está logado
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['status' => 'error', 'message' => 'Usuário não está logado']);
    exit();
}

// Detalhes da conexão com o banco de dados
$host = 'localhost';
$db = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';

// Cria a conexão
$conn = new mysqli($host, $user, $pass, $db);

// Verifica a conexão
if ($conn->connect_error) {
    die("Erro na conexão com o banco de dados: " . $conn->connect_error);
}

// Define o charset
$conn->set_charset($charset);

$userId = $_SESSION['user_id'];
$follows = $_POST['follows'];

$result = [];

// Para cada item na lista de follows, verifica o status no banco de dados
foreach ($follows as $follow) {
    $stmt = $conn->prepare("SELECT * FROM follows WHERE user_id = ? AND follow_type = ? AND follow_value = ?");
    $stmt->bind_param("iss", $userId, $follow['follow_type'], $follow['follow_value']);
    $stmt->execute();
    $res = $stmt->get_result();
    
    // Se encontrado, marca como "following", senão "not_following"
    if ($res->num_rows > 0) {
        $result[] = [
            'follow_type' => $follow['follow_type'], 
            'follow_value' => $follow['follow_value'], 
            'status' => 'following'
        ];
    } else {
        $result[] = [
            'follow_type' => $follow['follow_type'], 
            'follow_value' => $follow['follow_value'], 
            'status' => 'not_following'
        ];
    }
}

// Retorna os resultados como JSON
echo json_encode($result);

// Fecha a conexão com o banco de dados
$conn->close();
?>
