<?php
require_once __DIR__ . '/bootstrap.php';

$action = route_action();
if ($action === 'auth_register') handle_register();
if ($action === 'auth_login') handle_login();
if ($action === 'auth_logout') handle_logout();

json_fail('UNKNOWN_ACTION', 'No such auth action: ' . $action, 404);

function handle_register() {
    $pdo = pdo();
    $username = trim((string)param('username',''));
    $email = trim((string)param('email',''));
    $password = (string)param('password','');
    if ($username === '' || $email === '' || $password === '') {
        json_fail('BAD_REQUEST','username, email, password required', 422);
    }
    // Check conflicts
    $stmt = $pdo->prepare("SELECT ID FROM user_myhashtag WHERE email = :email OR username = :username LIMIT 1");
    $stmt->execute([':email'=>$email, ':username'=>$username]);
    if ($stmt->fetch()) json_fail('ALREADY_EXISTS','User exists', 409);

    $hash = password_hash($password, PASSWORD_DEFAULT);
    $stmt = $pdo->prepare("INSERT INTO user_myhashtag (username, email, senha, created_at, status) VALUES (:u,:e,:s,NOW(),'active')");
    $stmt->execute([':u'=>$username, ':e'=>$email, ':s'=>$hash]);
    $id = (int)$pdo->lastInsertId();

    $_SESSION['user'] = ['ID'=>$id,'username'=>$username,'email'=>$email];
    json_ok(['user'=>$_SESSION['user']]);
}

function handle_login() {
    $pdo = pdo();
    $ident = trim((string)param('identifier', param('email', param('username',''))));
    $password = (string)param('password','');
    if ($ident === '' || $password === '') json_fail('BAD_REQUEST','identifier and password required', 422);

    $stmt = $pdo->prepare("SELECT * FROM user_myhashtag WHERE email = :id OR username = :id LIMIT 1");
    $stmt->execute([':id'=>$ident]);
    $u = $stmt->fetch();
    if (!$u) json_fail('INVALID_CREDENTIALS','User not found', 401);

    $dbpass = (string)($u['senha'] ?? '');

    $ok = false;
    if ($dbpass !== '' && strlen($dbpass) >= 55 && password_verify($password, $dbpass)) {
        $ok = true;
    } elseif ($password === $dbpass) {
        $ok = true; // legacy plaintext
        // upgrade to hash
        try {
            $hash = password_hash($password, PASSWORD_DEFAULT);
            $up = $pdo->prepare("UPDATE user_myhashtag SET senha = :s WHERE ID = :id");
            $up->execute([':s'=>$hash, ':id'=>$u['ID']]);
        } catch (Throwable $e) {}
    }
    if (!$ok) json_fail('INVALID_CREDENTIALS','Wrong password', 401);

    $_SESSION['user'] = ['ID'=>(int)$u['ID'], 'username'=>$u['username'], 'email'=>$u['email']];
    json_ok(['user'=>$_SESSION['user']]);
}

function handle_logout() {
    session_destroy();
    json_ok(['message'=>'logged_out']);
}
