<?php
require_once __DIR__ . '/../config.php';

/**
 * File: api_comment_pin.php
 * POST { comment_id, feed_id, action:'pin'|'unpin' }
 * Permite pin/unpin se admin OU autor do feed
 */
session_start();
header('Content-Type: application/json; charset=utf-8');

$host = 'localhost';
$db   = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=$charset", $user, $pass, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success'=>false,'error'=>'db_connection_failed']);
    exit;
}

function me(PDO $pdo){
    if (!isset($_SESSION['username'])) return null;
    $st = $pdo->prepare("SELECT ID, username, user_role FROM user_myhashtag WHERE username = ? LIMIT 1");
    $st->execute([$_SESSION['username']]);
    return $st->fetch(PDO::FETCH_ASSOC) ?: null;
}
function isAdmin($u){ return $u && strtolower($u['user_role'] ?? '')==='admin'; }
function feedAuthor(PDO $pdo, int $feedId): ?string {
    $st = $pdo->prepare("SELECT author FROM pinfeeds WHERE id = ? LIMIT 1");
    $st->execute([$feedId]);
    $a = $st->fetchColumn();
    return $a ? (string)$a : null;
}

if ($_SERVER['REQUEST_METHOD']!=='POST'){ http_response_code(405); echo json_encode(['success'=>false]); exit; }

$u = me($pdo);
if (!$u){ echo json_encode(['success'=>false,'error'=>'not_logged_in']); exit; }

$payload = json_decode(file_get_contents('php://input'), true);
$cid = isset($payload['comment_id']) ? (int)$payload['comment_id'] : 0;
$fid = isset($payload['feed_id']) ? (int)$payload['feed_id'] : 0;
$act = isset($payload['action']) ? $payload['action'] : 'pin';
if ($cid<=0 || $fid<=0){ echo json_encode(['success'=>false,'error'=>'invalid_params']); exit; }

$author = feedAuthor($pdo, $fid);
$can = isAdmin($u) || ($author && strtolower($author)===strtolower($u['username']));
if (!$can){ echo json_encode(['success'=>false,'error'=>'forbidden']); exit; }

if ($act==='unpin'){
    $pdo->prepare("DELETE FROM comments_pins WHERE comment_id = ?")->execute([$cid]);
    echo json_encode(['success'=>true, 'action'=>'unpin']); exit;
}
// pin
$pdo->prepare("INSERT INTO comments_pins (feed_id, comment_id, user_id, created_at) VALUES (?, ?, ?, NOW()) ON DUPLICATE KEY UPDATE user_id = VALUES(user_id), created_at = NOW()")->execute([$fid, $cid, $u['ID']]);
echo json_encode(['success'=>true, 'action'=>'pin']); exit;
