<?php
require_once __DIR__ . '/../config.php';

// api_follow.php
session_start();
header('Content-Type: application/json; charset=utf-8');

$host = 'localhost';
$db   = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=$charset", $user, $pass, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success'=>false,'error'=>'db_connection_failed']);
    exit;
}

function getUserId(PDO $pdo): ?int {
    if (!isset($_SESSION['username'])) return null;
    $st = $pdo->prepare("SELECT ID FROM user_myhashtag WHERE username = :u LIMIT 1");
    $st->execute([':u' => $_SESSION['username']]);
    $r = $st->fetch(PDO::FETCH_ASSOC);
    return $r ? (int)$r['ID'] : null;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success'=>false,'error'=>'method_not_allowed']);
    exit;
}

$payload = json_decode(file_get_contents('php://input'), true);
$follow_type  = isset($payload['follow_type']) ? $payload['follow_type'] : '';
$follow_value = isset($payload['follow_value']) ? trim($payload['follow_value']) : '';

$validTypes = ['author','source_domain','tag'];
if (!in_array($follow_type, $validTypes, true) || $follow_value === '') {
    echo json_encode(['success'=>false, 'error'=>'invalid_params']);
    exit;
}

$userId = getUserId($pdo);
if (!$userId) { echo json_encode(['success'=>false, 'error'=>'not_logged_in']); exit; }

try {
    $st = $pdo->prepare("SELECT id FROM follows WHERE user_id = ? AND follow_type = ? AND follow_value = ? LIMIT 1");
    $st->execute([$userId, $follow_type, $follow_value]);
    $rowId = $st->fetchColumn();

    if ($rowId) {
        $del = $pdo->prepare("DELETE FROM follows WHERE id = ?");
        $del->execute([$rowId]);
        echo json_encode(['success'=>true, 'following'=>false, 'action'=>'unfollowed']);
    } else {
        $ins = $pdo->prepare("INSERT INTO follows (user_id, follow_type, follow_value) VALUES (?, ?, ?)");
        $ins->execute([$userId, $follow_type, $follow_value]);
        echo json_encode(['success'=>true, 'following'=>true, 'action'=>'followed']);
    }
} catch (Exception $e) {
    echo json_encode(['success'=>false,'error'=>'db_error']);
}
