<?php
require_once __DIR__ . '/../config.php';

/**
 * =========================================================
 *  File: api_share_log.php
 *  Purpose: Increment share counters per feed/channel
 *  Input: POST JSON { feed_id:int, channel:string }
 *  Output: { success: true, total: <sum for feed> }
 *  Notes:
 *   - Sanitizes `channel`.
 *   - Upserts into `share_stats`.
 * =========================================================
 */
header('Content-Type: application/json; charset=utf-8');

$host    = 'localhost';
$db      = 'digupdog_FEED';
$user    = 'digupdog_FEEDadmin';
$pass    = 'Raimundinho1';
$charset = 'utf8mb4';

try {
    $pdo = new PDO(
        "mysql:host={$host};dbname={$db};charset={$charset}",
        $user,
        $pass,
        [ PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
          PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC ]
    );
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'db_connection_failed']);
    exit;
}

$raw  = file_get_contents('php://input');
$data = json_decode($raw, true) ?: [];

$feed_id = isset($data['feed_id']) ? (int)$data['feed_id'] : 0;
$channel = isset($data['channel']) ? trim((string)$data['channel']) : 'other';
$channel = substr(preg_replace('/[^a-z0-9\-\._]/i', '', $channel), 0, 32);

if ($feed_id <= 0 || $channel === '') {
    echo json_encode(['success' => false, 'error' => 'invalid_params']);
    exit;
}

try {
    $stmt = $pdo->prepare(
        "INSERT INTO share_stats (feed_id, channel, count, last_shared_at)
         VALUES (:feed_id, :channel, 1, NOW())
         ON DUPLICATE KEY UPDATE count = count + 1, last_shared_at = NOW()"
    );
    $stmt->execute([':feed_id' => $feed_id, ':channel' => $channel]);

    $sum = $pdo->prepare("SELECT COALESCE(SUM(count),0) FROM share_stats WHERE feed_id = ?");
    $sum->execute([$feed_id]);
    $total = (int)$sum->fetchColumn();

    echo json_encode(['success' => true, 'total' => $total]);
} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'db_error']);
}
