<?php
require_once __DIR__ . '/../config.php';

/**
 * =========================================================
 *  File: api_user_avatar.php
 *  Purpose: Resolve avatar URL by username
 *  Input: GET username
 *  Output: { success: true, avatar_url: "https://..." }
 *  Notes:
 *    - Busca em 'users.profile_picture'. Se não houver, devolve default.
 * =========================================================
 */
header('Content-Type: application/json; charset=utf-8');

$host = 'localhost';
$db   = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=$charset", $user, $pass, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success'=>false,'error'=>'db_connection_failed']); exit;
}

$username = isset($_GET['username']) ? trim($_GET['username']) : '';
if ($username === '') { echo json_encode(['success'=>false,'error'=>'missing_username']); exit; }

$default = 'https://myhashtag.io/static/default-avatar.png';

try {
    $st = $pdo->prepare("SELECT profile_picture FROM users WHERE username = :u LIMIT 1");
    $st->execute([':u'=>$username]);
    $pic = $st->fetchColumn();
    if ($pic && filter_var($pic, FILTER_VALIDATE_URL)) {
        echo json_encode(['success'=>true, 'avatar_url'=>$pic]); exit;
    }

    // (Opcional) Se tiver outra fonte de avatar, consultar aqui.

    echo json_encode(['success'=>true, 'avatar_url'=>$default]); exit;
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success'=>true, 'avatar_url'=>$default]); exit;
}
