<?php
require_once __DIR__ . '/../config.php';

// api_user_search.php
declare(strict_types=1);
session_start();
header('Content-Type: application/json; charset=utf-8');

$cfg = [
  'host' => 'localhost',
  'db'   => 'digupdog_FEED',
  'user' => 'digupdog_FEEDadmin',
  'pass' => 'Raimundinho1',
  'charset' => 'utf8mb4'
];

$q = trim($_GET['q'] ?? '');

$mysqli = @new mysqli($cfg['host'], $cfg['user'], $cfg['pass'], $cfg['db']);
if ($mysqli->connect_error) { echo json_encode([]); exit; }
$mysqli->set_charset($cfg['charset']);

if ($q === '') { echo json_encode([]); exit; }

$qLike = $q.'%';
$stmt = $mysqli->prepare("SELECT id, username, profile_picture FROM user_myhashtag WHERE username LIKE ? ORDER BY username LIMIT 12");
$stmt->bind_param('s', $qLike);
$items = [];
if ($stmt->execute()) {
  $rs = $stmt->get_result();
  while ($row = $rs->fetch_assoc()) {
    $items[] = [
      'user_id' => (int)$row['id'],
      'username' => $row['username'],
      'profile_picture' => $row['profile_picture'] ?: 'https://myhashtag.io/static/default-avatar.png'
    ];
  }
}
$stmt->close();
echo json_encode($items, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
