<?php
/**
 * =========================================================
 * File: config.php
 * Project: DigUpDOG - Social Feed Network
 * Version: 2.0
 * Date: 2025-10-11
 * =========================================================
 */

// Prevent direct access
if (!defined('DIGUPDOG_APP')) {
    define('DIGUPDOG_APP', true);
}

// Error Reporting (Development)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// ========== DATABASE CONFIGURATION ==========
define('DB_HOST', 'localhost');
define('DB_NAME', 'digupdog_FEED');
define('DB_USER', 'digupdog_FEEDadmin');
define('DB_PASS', 'Raimundinho1');
define('DB_CHARSET', 'utf8mb4');

// ========== SITE CONFIGURATION ==========
define('SITE_NAME', 'DigUpDOG');
define('SITE_TAGLINE', 'Discover, Save and Share the Best Links from the Web');

// Auto-detect base URL (works in ANY directory!)
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https://' : 'http://';
$host = $_SERVER['HTTP_HOST'] ?? 'localhost';
$script_path = dirname($_SERVER['SCRIPT_NAME'] ?? '');
$base_url = $protocol . $host . rtrim($script_path, '/');

define('SITE_URL', $base_url);
define('API_URL', $base_url . '/api');
define('ASSETS_URL', $base_url . '/assets');
define('BASE_PATH', rtrim($script_path, '/'));

// ========== FEATURE TOGGLES ==========
define('ENABLE_COMMENTS', true);
define('ENABLE_REACTIONS', true);
define('ENABLE_SHARING', true);
define('ENABLE_FAVORITES', true);
define('ENABLE_FOLLOW', true);
define('ENABLE_NOTIFICATIONS', true);
define('ENABLE_CHAT', false); // Optional - not implemented yet
define('ENABLE_PAYMENTS', false); // Optional - premium features

// ========== SECURITY SETTINGS ==========
define('SESSION_TIMEOUT', 3600); // 1 hour
define('SESSION_NAME', 'DIGUPDOG_SESSION');
define('RATE_LIMIT_REQUESTS', 100);
define('RATE_LIMIT_WINDOW', 60); // per minute
define('CSRF_TOKEN_NAME', 'digupdog_csrf_token');

// ========== MEDIA UPLOAD SETTINGS ==========
define('MAX_UPLOAD_SIZE', 10485760); // 10MB
define('ALLOWED_IMAGE_EXTENSIONS', ['jpg', 'jpeg', 'png', 'gif', 'webp']);
define('ALLOWED_VIDEO_EXTENSIONS', ['mp4', 'webm', 'ogg']);
define('UPLOAD_DIR', __DIR__ . '/uploads');
define('THUMBNAIL_SIZE', 300);

// ========== PAGINATION ==========
define('POSTS_PER_PAGE', 20);
define('COMMENTS_PER_PAGE', 50);
define('SEARCH_RESULTS_PER_PAGE', 20);

// ========== CACHE SETTINGS ==========
define('CACHE_ENABLED', true);
define('CACHE_LIFETIME', 3600); // 1 hour
define('CACHE_DIR', __DIR__ . '/cache');

// ========== API SETTINGS ==========
define('API_VERSION', '2.0');
define('API_RESPONSE_FORMAT', 'json');
define('API_REQUIRE_AUTH', false); // Set to true for production

// ========== DATABASE CONNECTION ==========
try {
    $pdo = new PDO(
        "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET,
        DB_USER,
        DB_PASS,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
            PDO::ATTR_PERSISTENT => false
        ]
    );

    // Alternative mysqli connection for legacy code
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    if ($conn->connect_error) {
        throw new Exception("MySQL connection failed: " . $conn->connect_error);
    }
    $conn->set_charset(DB_CHARSET);

} catch (PDOException $e) {
    die(json_encode([
        'success' => false,
        'error' => 'Database connection failed',
        'message' => $e->getMessage()
    ]));
} catch (Exception $e) {
    die(json_encode([
        'success' => false,
        'error' => 'Database error',
        'message' => $e->getMessage()
    ]));
}

// ========== HELPER FUNCTIONS ==========

/**
 * Get current user ID from session
 */
function getCurrentUserId() {
    return isset($_SESSION['user_id']) ? (int)$_SESSION['user_id'] : null;
}

/**
 * Check if user is logged in
 */
function isLoggedIn() {
    return isset($_SESSION['user_id']) && !empty($_SESSION['user_id']);
}

/**
 * Require authentication
 */
function requireAuth() {
    if (!isLoggedIn()) {
        header('HTTP/1.1 401 Unauthorized');
        die(json_encode([
            'success' => false,
            'error' => 'Authentication required'
        ]));
    }
}

/**
 * Send JSON response
 */
function jsonResponse($data, $statusCode = 200) {
    http_response_code($statusCode);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    exit;
}

/**
 * Sanitize input
 */
function sanitizeInput($input) {
    return htmlspecialchars(strip_tags(trim($input)), ENT_QUOTES, 'UTF-8');
}

/**
 * Generate CSRF token
 */
function generateCsrfToken() {
    if (empty($_SESSION[CSRF_TOKEN_NAME])) {
        $_SESSION[CSRF_TOKEN_NAME] = bin2hex(random_bytes(32));
    }
    return $_SESSION[CSRF_TOKEN_NAME];
}

/**
 * Verify CSRF token
 */
function verifyCsrfToken($token) {
    return isset($_SESSION[CSRF_TOKEN_NAME]) && hash_equals($_SESSION[CSRF_TOKEN_NAME], $token);
}

// ========== SESSION MANAGEMENT ==========
if (session_status() === PHP_SESSION_NONE) {
    ini_set('session.cookie_httponly', 1);
    ini_set('session.use_only_cookies', 1);
    ini_set('session.cookie_secure', 0); // Set to 1 for HTTPS
    session_name(SESSION_NAME);
    session_start();

    // Session timeout check
    if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > SESSION_TIMEOUT)) {
        session_unset();
        session_destroy();
        session_start();
    }
    $_SESSION['last_activity'] = time();
}

// ========== AUTOLOADER (Optional) ==========
spl_autoload_register(function ($class) {
    $file = __DIR__ . '/classes/' . str_replace('\\', '/', $class) . '.php';
    if (file_exists($file)) {
        require_once $file;
    }
});

// ========== TIMEZONE ==========
date_default_timezone_set('America/Sao_Paulo');

// ========== CONSTANTS ==========
define('NOW', time());
define('TODAY', date('Y-m-d'));
define('CONFIG_LOADED', true);

?>
