# DigUpDog Masonry – Checklist

**This package is self-contained and ready to upload into *any* directory.**  
All paths are relative; no `/public` redirect; no absolute URLs.

## ✅ What’s included (no omissions)
- Frontend (English-only UI)
  - `index.php` – Masonry grid (CSS columns), search + filters, Load more
  - `trending.php` – Trending feed
  - `sources.php` – Domain counts
  - `view.php` – Item details + comments
  - `profile.php`, `login.php`, `register.php`, `logout.php`
  - Assets in `public/css/` and `public/js/`
- API (file-based, no rewrite needed)
  - `api/router.php` – single entry point
  - `api/bootstrap.php` – DB, helpers, session
  - `api/feeds.php` – **get_pinfeeds**, get_feed, get_trending, get_sources, get_hashtags, search
  - `api/comments.php` – get_comments, post_comment
  - `api/reactions.php` – post_reaction (like/dislike) with fallback to `feed_reactions`
  - `api/favorites.php` – favorite_toggle, get_user_favorites
  - `api/follows.php` – follow_user (toggle)
  - `api/boards.php` – get_boards, board_add_item (enabled only if tables exist)
  - `api/chat.php` – get_chat_rooms, chat_send, chat_fetch (enabled only if tables exist)
  - `api/upload.php` – upload_media (images), stores in `/uploads` and DB (if table exists)
  - `api/linkpreview.php` – link_preview (cache-only, no external fetch)
  - `api/profile.php` – get_user_profile with counters
- Config
  - `config/config.php` pre-filled with your MySQL credentials
- Utilities
  - `.htaccess` (minimal & safe; no `/public` redirect)
  - `install/index.php` – Health check instead of redirect
  - `health.php` – JSON health endpoint
  - `uploads/` – writable folder with safe `.htaccess`

## 🧪 Quick test plan (5 steps)
1) Upload the whole folder to any directory (e.g. `/digupdog_masonry/`).
2) Visit `/digupdog_masonry/install/` → it should show **OK** for DB and link to **Home**.
3) Open `/digupdog_masonry/index.php` → cards should render. Use search/filters/sorting.
4) Open an item → comment. If asked to login, register then login (stored in `user_myhashtag.senha` with hash).
5) Try reactions and favorite – counters update; trending/sources pages load.

## Notes
- Popular/Trending are computed using `feed_views` + `pinfeeds.likes/dislikes` if available.
- Boards/Chat/Upload/OG preview are enabled only if their tables exist (graceful off if not).
- No Apache rewrite rules required. Endpoints are explicit, e.g.:  
  `api/router.php?action=get_pinfeeds`
