<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');
set_time_limit(1800);
ini_set('memory_limit', '512M');

$addedItemsCount = 0;
$failedItemsCount = 0;
$errors = [];

$configFilePath = __DIR__ . '/path_to_config.php'; // Use the correct path to config.php
$config = require $configFilePath;

try {
    $pdo = new PDO(
        "mysql:host={$config['db_host']};dbname={$config['db_name']};charset={$config['db_charset']}",
        $config['db_user'],
        $config['db_pass']
    );
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Failed to connect to the database: " . $e->getMessage());
}

function getThumbnail($xpath) {
    $queries = [
        '//meta[@property="og:image"]/@content',
        '//img[@class="post-thumbnail"]/@src',
        '//figure/img/@src',
        '//div[@class="post-thumbnail"]/img/@src',
        '//img[contains(@class, "wp-post-image")]/@src',
        '//video/@poster',
        '//img/@src'
    ];

    foreach ($queries as $query) {
        $nodes = $xpath->query($query);
        if ($nodes->length > 0 && $nodes->item(0)->nodeValue) {
            return trim($nodes->item(0)->nodeValue);
        }
    }

    return 'fallback_image.jpg';
}

function generateRandomAuthor() {
    $authors = [
        "John", "Jane", "Michael", "Emily", "David", "Sarah", "William", "Olivia", "James", "Sophia",
        "Daniel", "Isabella", "Matthew", "Ava", "Ethan", "Mia", "Alexander", "Amelia", "Benjamin", "Harper",
        "Henry", "Ella", "Joseph", "Abigail", "Samuel", "Grace", "Jackson", "Scarlett", "David", "Chloe",
        "William", "Evelyn", "James", "Victoria", "Daniel", "Avery", "Anthony", "Luna", "Joshua", "Sofia"
    ];
    return $authors[array_rand($authors)];
}

function extractTagsFromTitle($title) {
    $title = preg_replace("/[.,\/#!$%\^&\*;:{}=\-_`~()]/", "", $title);
    $title = mb_strtolower($title);
    $words = explode(" ", $title);

    $commonWords = ["a", "an", "the", "and", "or", "but", "in", "at", "on", "with", "to", "–", "for", "is", "of", "that", "it", "by", "from", "as", "are", "was", "be", "has", "have", "will", "this", "which", "its", "about", "up", "more", "who", "also", "they", "out", "he", "she", "you", "their", "we", "her", "his", "them", "been", "these", "would", "some", "can", "like", "there", "if", "all", "my", "what", "so", "then", "into", "just", "over", "do", "than", "when", "other", "how", "our", "any", "new", "me", "after", "most", "made", "only", "time", "will", "where", "year", "years", "make", "does", "could", "were", "your", "good", "well", "them"];

    $keywords = array_filter($words, function ($word) use ($commonWords) {
        return !in_array($word, $commonWords) && mb_strlen($word) > 2;
    });

    return implode(',', $keywords);
}

// Websites para adicionar à tabela "feedsUsers"
$websites = [
"https://abc30.com/feed/",
"https://www.adaltas.com/en/rss.xml",
"https://feeds.feedburner.com/technologycrowds",
"https://jaypeeonline.net/feed/",
"https://technologyspell.com/feed/",
"https://www.techradar247.com/feed/",
"https://blacksportsonline.com/feed/",
"https://www.topbuzztrends.com/feed/",
"https://latina.com/feed/",
"https://bolavip.com/en/rss/feed"
];

foreach ($websites as $website) {
    try {
        $feed = simplexml_load_file($website);
    } catch (Exception $e) {
        echo "Error loading feed {$website}: {$e->getMessage()}\n";
        continue;
    }

    foreach ($feed->channel->item as $item) {
        $title = $item->title;
        $description = $item->description;
        $link = $item->link;
        $pubDate = date("Y-m-d H:i:s", strtotime($item->pubDate));
        


        // Tente obter o favicon a partir do domínio raiz do link
        $favicon = '';
        $parsedUrl = parse_url($link);
        if ($parsedUrl !== false && isset($parsedUrl['scheme']) && isset($parsedUrl['host'])) {
            $favicon = $parsedUrl['scheme'] . '://' . $parsedUrl['host'] . '/favicon.ico';
        }

        // Procurar a miniatura específica
        $thumbnail = '';
        if (isset($item->children('media', true)->thumbnail)) {
            $thumbnail = $item->children('media', true)->thumbnail->attributes()->url;
        } elseif (isset($item->children('media', true)->content)) {
            $thumbnail = $item->children('media', true)->content->attributes()->url;
        }

        if (empty($thumbnail)) {
            preg_match('/<img[^>]+src="([^">]+)"/i', $description, $matches);
            if (isset($matches[1])) {
                $thumbnail = $matches[1];
            }
        }

        try {
            if (empty($thumbnail)) {
                $content = file_get_contents($link);
                $dom = new DOMDocument();
                @$dom->loadHTML($content);
                $xpath = new DOMXpath($dom);
                $thumbnail = getThumbnail($xpath);
            }
        } catch (Exception $e) {
            echo "Error fetching thumbnail for {$link}: {$e->getMessage()}\n";
            continue;
        }


// Preencher as colunas adicionais
$image = isset($item->image) ? $item->image : '';
$guid = $item->guid;
$source = $website;
$updated = date("Y-m-d H:i:s");
$categories = isset($item->category) ? implode(",", $item->category) : '';
$channel = isset($feed->channel->title) ? $feed->channel->title : '';
$author = isset($item->author) ? $item->author : generateRandomAuthor();
$source_website = $parsedUrl['scheme'] . '://' . $parsedUrl['host'];
$tags = extractTagsFromTitle($title);

        $stmt = $pdo->prepare('SELECT COUNT(*) FROM pinfeeds WHERE link = ?');
        $stmt->execute([$link]);
        $count = $stmt->fetchColumn();

        if ($count == 0) {
            try {
                // ... (same as before)
            } catch (PDOException $e) {
                $errorMsg = "Error inserting into the database: " . $e->getMessage();
                echo $errorMsg . "\n";
                $errors[] = $errorMsg;
            }
        }
    }
}

echo "Items added: {$addedItemsCount}\n";
echo "Items failed: {$failedItemsCount}\n";
if (!empty($errors)) {
    echo "Errors:\n";
    echo implode("\n", $errors);
}
?>